﻿using System.ComponentModel.DataAnnotations;

namespace NaszEF.BazaDanych
{
    public class Osoba
    {
        [Key] public int Id { get; set; } //primary key = klucz główny
        public string Imię { get; set; }
        public string Nazwisko { get; set; }
        public int? NumerTelefonu { get; set; }

        public Adres Adres { get; set; }

        /*
        public Osoba(int id, string imię, string nazwisko, int? numerTelefonu, Adres adres)
        {
            Id = id;
            Imię = imię;
            Nazwisko = nazwisko;
            NumerTelefonu = numerTelefonu;
            Adres = adres;
        }
        */

        public override bool Equals(object? obj)
        {
            if (obj == null) return false;
            if (obj is not Osoba) return false;
            Osoba innaOsoba = (Osoba)obj;
            return
                Id == innaOsoba.Id &&
                Imię.Equals(innaOsoba.Imię) &&
                Nazwisko.Equals(innaOsoba.Nazwisko);
        }

        public override int GetHashCode()
        {
            return Id ^ Imię.GetHashCode() ^ Nazwisko.GetHashCode();
        }

        public override string ToString()
        {
            return $"{Id}. {Imię} {Nazwisko}, nr tel. {(NumerTelefonu.HasValue ? NumerTelefonu.Value.ToString() : "---")}, {Adres}";
        }
    }
}
