﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NaszEF.BazaDanych
{
    internal class BazaDanychOsóbDbContext : DbContext
    {
        public DbSet<Osoba> Osoby { get; set; }
        public DbSet<Adres> Adresy { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            Console.WriteLine("BazaDanychOsóbDbContext.OnConfiguring");
            //base.OnConfiguring(optionsBuilder);
            optionsBuilder.UseSqlite("Data Source=osoby.db");
            //optionsBuilder.UseLazyLoadingProxies();
        }
    }

    public class BazaDanychOsób : IDisposable
    {
        private BazaDanychOsóbDbContext dbc = new BazaDanychOsóbDbContext();

        public BazaDanychOsób()
        {
            dbc.Database.EnsureCreated();
        }

        public void Dispose()
        {
            dbc.Dispose();
        }

        //CRUD
        public Osoba? PobierzOsobę(int idOsoby)
        {
            return dbc.Osoby.FirstOrDefault(o => o.Id == idOsoby);
        }

        public Osoba? this[int idOsoby]
        {
            get => PobierzOsobę(idOsoby);
        }

        public int[] IdentyfikatoryOsób
        {
            get
            {
                return dbc.Osoby.Select(o => o.Id).OrderBy(id => id).ToArray();
            }
        }

        public int DodajOsobę(Osoba osoba)
        {
            if (osoba == null) throw new ArgumentNullException("Podano pustą referencję do obiektu osoby jako argument");
            if (osoba.Adres == null) throw new ArgumentNullException("Podano pustą referencję do obiektu adresu jako argument");

            if (dbc.Osoby.ToArray().Any(o => o.Equals(osoba)))
                return osoba.Id; //id istniejącej osoby;
            else
            {
                //sami nadajemy id
                if (dbc.Osoby.Any(o => o.Id == osoba.Id))
                    osoba.Id = dbc.Osoby.Max(o => o.Id) + 1;
            }

            //dublowanie adresów
            Adres? adres = dbc.Adresy.ToArray().FirstOrDefault(a => a.Equals(osoba.Adres));
            if(adres != null) osoba.Adres = adres;

            //zapis
            dbc.Osoby.Add(osoba);
            dbc.SaveChanges();

            return osoba.Id;
        }

        #region Debugowanie
#if DEBUG
        public Osoba[] Osoby { get { return dbc.Osoby.ToArray(); } }
        public Adres[] Adresy { get { return dbc.Adresy.ToArray(); } }
#endif
        #endregion
    }
}
