﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NaszEF.BazaDanych
{
    public class Adres
    {
        [Key] public int Id { get; set; }
        public string Miasto { get; set; }
        public string Ulica { get; set; }
        public int NumerDomu { get; set; }
        public int? NumerMieszkania { get; set; }

        public Adres(int id, string miasto, string ulica, int numerDomu, int? numerMieszkania)
        {
            Id = id;
            Miasto = miasto;
            Ulica = ulica;
            NumerDomu = numerDomu;
            NumerMieszkania = numerMieszkania;
        }

        public override bool Equals(object? obj)
        {
            if(obj == null) return false;
            if (obj is not Adres) return false;
            Adres innyAdres = (Adres)obj;            
            return 
                Miasto.Equals(innyAdres.Miasto) &&
                Ulica.Equals(innyAdres.Ulica) &&
                NumerDomu == innyAdres.NumerDomu &&
                NumerMieszkania == innyAdres.NumerMieszkania;
        }

        public override int GetHashCode()
        {
            return Miasto.GetHashCode() ^ Ulica.GetHashCode() ^ NumerDomu ^ NumerMieszkania.GetHashCode();
        }

        public override string ToString()
        {
            return $"{Miasto}, {Ulica} {NumerDomu}/{NumerMieszkania}".TrimEnd('/');
        }
    }
}
