﻿namespace UMK
{
    using Turing.Model;

    internal class Program
    {
        //TODO: parametry uruchomienia programu - nazwy plików
        private static void wyświetlStan(object? sender, Turing.Model.Maszyna.StateChangedEventArgs e)
        {
            string? stan = e.OpisStanu;
            Console.WriteLine(stan);
            if (e.OstatniaInstrukcja != null) Console.WriteLine("Wykonano instrukcję: " + e.OstatniaInstrukcja);
        }

        private static void wyświetlOstatnieOstrzeżenie(object? sender, EventArgs e)
        {
            Maszyna? maszyna = sender as Maszyna;
            if (maszyna == null) throw new NullReferenceException("Pusta referencja do obiektu maszyny Turinga");
            string ostatnieOstrzeżenie = maszyna.Ostrzeżenia.Last();
            Console.WriteLine("Ostrzeżenie: " + ostatnieOstrzeżenie);
        }

        static void Main(string[] args)
        {
            string ścieżkaPlikuStanu = "stan.txt";
            string ścieżkaPlikuProgramu = "program.txt";

            try
            {
                if (args.Length > 0)
                {
                    if (args.Length != 2) throw new ArgumentException("Nieodpowiednia liczba parametrów programu");
                    ścieżkaPlikuStanu = args[0];
                    ścieżkaPlikuProgramu = args[1];
                }

                Console.WriteLine("Maszyna Turinga");
                Maszyna maszynaTuringa = new Maszyna();
                maszynaTuringa.StateChanged += wyświetlStan;
                maszynaTuringa.DodaneOstrzeżenie += wyświetlOstatnieOstrzeżenie;
                Console.WriteLine($"Wczytuję stan z pliku '{ścieżkaPlikuStanu}'...");
                maszynaTuringa.WczytajStan(ścieżkaPlikuStanu);
                Console.WriteLine($"Wczytuję program z pliku '{ścieżkaPlikuProgramu}'...");
                maszynaTuringa.WczytajProgram(ścieżkaPlikuProgramu);
                maszynaTuringa.WykonajProgram();
            }
            catch (ProgramNieJestPoprawnyException)
            {
                Console.WriteLine("Program nie jest poprawny");
            }
            catch (StanGłowicyNieJestPoprawnyException)
            {
                Console.WriteLine("Stan maszyny nie jest poprawny");
            }
            catch (TuringException exc)
            {
                Console.Error.WriteLine("Inny błąd związany z działaniem maszyny Turingi");
                if (exc.Message != null) Console.Error.WriteLine("Opis błędu: " + exc.Message);
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Inny błąd: " + exc.Message);
            }

            Console.WriteLine("OK.");
        }
    } 
}
