﻿using System.Linq;
using System.Xml.Linq;

namespace LINQ
{
    internal class Program
    {
        public class Osoba : IComparable<Osoba>, ICloneable
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;

            public override string ToString()
            {
                return $"{Id}. {Imię} {Nazwisko} (tel. {NumerTelefonu}, wiek {Wiek})";
            }

            public int CompareTo(Osoba other)
            {
                return Wiek.CompareTo(other.Wiek);
            }

            public object Clone()
            {
                return new Osoba() { Id = this.Id, Imię = this.Imię, Nazwisko = this.Nazwisko, NumerTelefonu = this.NumerTelefonu, Wiek = this.Wiek };
            }
        }

        private static void wydrukujKolekcję<T>(IEnumerable<T> kolekcja)
        {
            Console.WriteLine("Kolekcja:");
            foreach(T element in kolekcja)
            {
                if (element != null) Console.WriteLine(element.ToString());
                else Console.WriteLine("<Pusty element>");
            }
        }

        static void Main(string[] args)
        {
            List<Osoba> osoby = new List<Osoba>()
            {
                new Osoba() { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 52 },
                new Osoba() { Id = 2, Imię = "Andrzej", Nazwisko = "Mleczko", NumerTelefonu = 27389838, Wiek = 53 },
                new Osoba() { Id = 3, Imię = "Wiktor", Nazwisko = "Matulewski", NumerTelefonu = 3287233, Wiek = 18 },
                new Osoba() { Id = 4, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 87983847, Wiek = 5 },
                new Osoba() { Id = 5, Imię = "Harry", Nazwisko = "Potter", NumerTelefonu = 3448753, Wiek = 4 },
                new Osoba() { Id = 6, Imię = "Gordon", Nazwisko = "Summers", NumerTelefonu = 3845739, Wiek = 25 },
                new Osoba() { Id = 6, Imię = "Karolina", Nazwisko = "Matulewska", NumerTelefonu = 3845739, Wiek = 26 }
            };

            wydrukujKolekcję(osoby);

            var zapytanie = from Osoba osoba in osoby
                            where !osoba.Imię.EndsWith("a")
                            orderby osoba.Wiek descending
                            select osoba.ToString();

            wydrukujKolekcję(zapytanie);

            Console.WriteLine("Max: " + osoby.Max(o => o.Wiek));
            Console.WriteLine("Max: " + osoby.Max());
            Console.WriteLine("Suma: " + osoby.Sum(o => o.Wiek));

            var zapytanie2 = osoby.Where(o => !o.Imię.EndsWith("a")).OrderByDescending(o => o.Wiek).Select(o => o.ToString());

            wydrukujKolekcję(zapytanie2);

            bool czyJakakolwiekOsobaJestDorosła = osoby.Any(o => o.Wiek > 18);
            Console.WriteLine("czyJakakolwiekOsobaJestDorosła: " + czyJakakolwiekOsobaJestDorosła);

            bool czyWszystkieOsobySąDorosłe = osoby.All(o => o.Wiek > 18);
            Console.WriteLine("czyWszystkieOsobySąDorosłe: " + czyWszystkieOsobySąDorosłe);

            Console.WriteLine("--------------------------");

            /*
            var zapytanie3 = from Osoba osoba in osoby
                            where !osoba.Imię.EndsWith("a")
                            orderby osoba.Wiek descending
                            select osoba;

            wydrukujKolekcję(osoby);
            wydrukujKolekcję(zapytanie3);

            zapytanie3.ElementAt(0).Imię = "Barnaba";

            wydrukujKolekcję(osoby);
            wydrukujKolekcję(zapytanie3);
            */

            Console.WriteLine("--------------------------");

            var zapytanie4 = from Osoba osoba in osoby
                             where !osoba.Imię.EndsWith("a")
                             orderby osoba.Wiek descending
                             select osoba.Clone() as Osoba;

            wydrukujKolekcję(osoby);
            wydrukujKolekcję(zapytanie4);

            zapytanie4.ElementAt(0).Imię = "Barnaba"; //typowy błąd logiczny - ulotne dane

            wydrukujKolekcję(osoby);
            wydrukujKolekcję(zapytanie4);

            Console.WriteLine("--------------------------");

            var zapytanie5 = from Osoba osoba in osoby
                             where !osoba.Imię.EndsWith("a")
                             orderby osoba.Wiek descending
                             select new { osoba.Imię, osoba.Nazwisko };

            wydrukujKolekcję(osoby);
            wydrukujKolekcję(zapytanie5);

            Console.WriteLine("--------------------------");

            var zapytanie6 = from Osoba osoba in osoby
                             group osoba by osoba.Nazwisko.Substring(0, osoba.Nazwisko.Length - 1) into grupa
                             select grupa;

            foreach(var grupa in zapytanie6)
            {
                Console.WriteLine("Grupa: " + grupa.Key);
                wydrukujKolekcję(grupa);
                Console.WriteLine();
            }

            var listaOsóbPełnoletnich = from osoba in osoby
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        //select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
                                        select osoba;
            var listaKobiet = from osoba in osoby
                              where osoba.Imię.EndsWith("a")
                              //select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
                              select osoba;

            wydrukujKolekcję(listaOsóbPełnoletnich);
            wydrukujKolekcję(listaKobiet);

            //var listaOsóbPełnoletnich_Lub_Kobiet = listaOsóbPełnoletnich.Concat(listaKobiet);
            //var listaOsóbPełnoletnich_Lub_Kobiet = listaOsóbPełnoletnich.Concat(listaKobiet).Distinct();
            var listaOsóbPełnoletnich_Lub_Kobiet = listaOsóbPełnoletnich.Union(listaKobiet);            

            wydrukujKolekcję(listaOsóbPełnoletnich_Lub_Kobiet);

            var listaOsóbPełnoletnich_I_Kobiet = listaOsóbPełnoletnich.Intersect(listaKobiet);

            wydrukujKolekcję(listaOsóbPełnoletnich_I_Kobiet);

            var listaOsóbPełnoletnich_AleNie_Kobiet = listaOsóbPełnoletnich.Except(listaKobiet);

            wydrukujKolekcję(listaOsóbPełnoletnich_AleNie_Kobiet);

            Console.WriteLine("--------------------------");

            //Łączenie źródeł danych

            var listaTelefonów = from osoba in osoby
                                 select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in osoby
                                   select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            wydrukujKolekcję(listaTelefonów);
            wydrukujKolekcję(listaPersonaliów);

            var listaPersonaliówZTelefonami = from telefon in listaTelefonów
                                              join personalia in listaPersonaliów
                                              on telefon.Id equals personalia.Id
                                              select new
                                              {
                                                  telefon.Id,
                                                  personalia.Imię,
                                                  personalia.Nazwisko,
                                                  telefon.NumerTelefonu
                                              };

            wydrukujKolekcję(listaPersonaliówZTelefonami);


            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("osoby",
                    from osoba in osoby
                    orderby osoba.Nazwisko, osoba.Imię
                    select new XElement("osoba",
                        new XAttribute("Id", osoba.Id),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("Wiek", osoba.Wiek)
                    )
                )
            );
            xml.Save("osoby.xml");
        }
    }
}
