﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Turing.Model
{
    public class Program
    {
        private Czwórka[]? program = null;

        public Program(Czwórka[] instrukcje)
        {
            this.program = instrukcje;
            SprawdźPoprawnośćProgramu(program);
        }

        //TODO: ZADANIE NA ZAJĘCIA: tą metodę obłożyć testem
        //TODO: ZADANIE NA ZAJĘCIA: obłożyć testami jednostkowymi
        public static bool SprawdźPoprawnośćProgramu(Czwórka[] program)
        {
            //TODO: nie sprawdzamy, czy nie powtarzają się linie, o tym samym początku!!!!!
            if (program == null) throw new BrakProgramuException();            
            for (int i = 0; i < program.Length; ++i)
            {
                //if (!sprawdźPoprawnośćInstrukcji(program[i])) return false;
                if (!program[i].SprawdźPoprawność()) return false;
            }
            return true;
        }

        public Czwórka ZnajdźOdpowiedniąInstrukcję(char stanGłowicy, char wartośćNaTaśmie)
        {
            if (program == null) throw new BrakProgramuException();
            foreach (Czwórka instrukcja in program)
            {
                //if (instrukcja.ssg == stanGłowicy && instrukcja.szk == taśma[pozycjaGłowicy])
                if (instrukcja.ssg == stanGłowicy && instrukcja.szk == wartośćNaTaśmie)
                {
                    return instrukcja;
                }
            }
            throw new NieZnalezionoInstrukcjiException();
        }

        public static Czwórka ParsujLinię(string linia)
        {
            if (linia.Length != 4) throw new LiniaProgramuNieJestPoprawna();
            Czwórka czwórka = new Czwórka(linia[0], linia[1], linia[2], linia[3]);
            if (!czwórka.SprawdźPoprawność()) throw new LiniaProgramuNieJestPoprawna();
            return czwórka;
        }

        //pseudokonstruktor
        public static Program WczytajProgram(string ścieżkaPliku)
        {
            string[] linie = File.ReadAllLines(ścieżkaPliku);
            Czwórka[] instrukcje = new Czwórka[linie.Length];
            for (int i = 0; i < linie.Length; i++)
            {
                instrukcje[i] = ParsujLinię(linie[i]);
            }
            if (!SprawdźPoprawnośćProgramu(instrukcje)) throw new ProgramNieJestPoprawnyException();
            return new Program(instrukcje);
        }
    }
}
