using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace TestyJednostkoweTuring
{
    using Turing.Model;


    [TestClass]
    public class TestMaszynaTuringa
    {
        //TODO: ZADANIE NA ZAJCIA: zrb test metody testujcej program
        private List<Czwrka> program = new List<Czwrka>()
        {
            new Czwrka('q','A','B','q'),
            new Czwrka('q','B','R','s'),
            new Czwrka('s','A','W','a'),
            new Czwrka('a','A','L','q'),
            new Czwrka('a','W','L','q'),
            new Czwrka('s','W','L','q')
        };

        private bool uruchomPrywatnMetodSprawdPoprawnoGowicy(Maszyna maszyna)
        {
            MiniPrivateObject mpo = new MiniPrivateObject(maszyna);
            object? wynik = mpo.RunPrivateMethod("sprawdPoprawnoGowicy");
            if (wynik is not bool) throw new Exception("Wynik nie jest wartoci logiczn");
            return (bool)wynik;
        }

        private bool uruchomPrywatnMetodWykryjZaptlenie(Maszyna maszyna)
        {
            MiniPrivateObject mpo = new MiniPrivateObject(maszyna);
            object? wynik = mpo.RunPrivateMethod("wykryjZaptlenie");
            if (wynik is not bool) throw new Exception("Wynik nie jest wartoci logiczn");
            return (bool)wynik;
        }

        /*
        private bool uruchomPrywatnStatycznMetodSprawdPoprawnoInstrukcji(Czwrka instrukcja)
        {             
            object? wynik = MiniPrivateObject.RunPrivateStaticMethod("sprawdPoprawnoInstrukcji", instrukcja);
            if (wynik is not bool) throw new Exception("Wynik nie jest wartoci logiczn");
            return (bool)wynik;
        }
        */

        [TestMethod]
        public void TestSprawdzaniaPoprawnociStanuGowicy()
        {
            //metodyka pisania testw jednostkowych = AAA

            //arrange - przygotuj
            Maszyna maszynaTuringa = new Maszyna();            

            //act - dziaaj
            //TODO: zmie stan gowicy w dodatkowym tecie
            bool wynik = uruchomPrywatnMetodSprawdPoprawnoGowicy(maszynaTuringa);

            //assert - weryfikuj
            Assert.IsTrue(wynik);
        }

        [TestMethod]        
        public void TestSprawdzaniaPoprawnociInstrukcji()
        {
            //metodyka pisania testw jednostkowych = AAA

            //arrange - przygotuj            
            Czwrka instrukcja1 = new Czwrka('a', 'A', 'B', 'b');
            Czwrka instrukcja2 = new Czwrka('1', 'A', 'B', 'b');
            Czwrka instrukcja3 = new Czwrka('1', 'A', 'B', 'C');

            //act - dziaaj
            bool wynik1 = instrukcja1.SprawdPoprawno();
            bool wynik2 = instrukcja2.SprawdPoprawno();
            bool wynik3 = instrukcja3.SprawdPoprawno();

            //assert - weryfikuj
            Assert.IsTrue(wynik1);
            Assert.IsFalse(wynik2);
            Assert.IsFalse(wynik3);
        }

        [TestMethod]
        public void TestWykrywaniaZaptlenia1()
        {
            Maszyna maszyna = new Maszyna();
            string[] historiaStanw = { "qBAAB", "BsAAB", "BaWAB", "qBWAB", "BsWAB", "qBWAB", "BsWAB", "qBWAB" };
            new MiniPrivateObject(maszyna).UstawPrywatnePole("historiaStanw", historiaStanw.ToList());

            bool wynik = uruchomPrywatnMetodWykryjZaptlenie(maszyna);

            Assert.IsTrue(wynik);
        }

        [TestMethod]
        public void TestWykrywaniaZaptlenia2()
        {
            Maszyna maszyna = new Maszyna();
            string[] historiaStanw = { "qBAAB", "BsAAB", "BaWAB", "qBWAB", "BsWAB" };
            new MiniPrivateObject(maszyna).UstawPrywatnePole("historiaStanw", historiaStanw.ToList());

            bool wynik = uruchomPrywatnMetodWykryjZaptlenie(maszyna);

            Assert.IsFalse(wynik);
        }

        //TODO: pokaza expected exception
    }
}