﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using Turing.Model;

namespace TestyJednostkoweTuring
{
    internal class MiniPrivateObject
    {
        private object instancjaObiektu;

        public MiniPrivateObject(object instancjaObiektu)
        {
            this.instancjaObiektu = instancjaObiektu;
        }

        public object? RunPrivateMethod(string methodName, params object?[]? parametry)
        {
            Type typ = instancjaObiektu.GetType();
            //var a = typ.GetMethods(BindingFlags.NonPublic | BindingFlags.Instance);
            MethodInfo? mi = typ.GetMethod(methodName, BindingFlags.NonPublic | BindingFlags.Instance);
            if (mi == null) throw new Exception("Metoda o podanej nazwie nie istnieje");

            object? wynik = mi.Invoke(instancjaObiektu, parametry);
            return wynik;
        }

        public static object? RunPrivateStaticMethod(Type type, string methodName, params object?[]? parametry)
        {            
            //var a = type.GetMethods(BindingFlags.NonPublic | BindingFlags.Static);
            MethodInfo? mi = type.GetMethod(methodName, BindingFlags.NonPublic | BindingFlags.Static);
            if (mi == null) throw new Exception("Metoda o podanej nazwie nie istnieje");

            object? wynik = mi.Invoke(null, parametry);
            return wynik;
        }

        public void UstawPrywatnePole(string fieldName,  object? value)
        {
            Type typ = instancjaObiektu.GetType();
            FieldInfo? fieldInfo = typ.GetField(fieldName, BindingFlags.NonPublic | BindingFlags.Instance);
            if (fieldInfo == null) throw new Exception("Nie udało się uzyskać dostępu do pola");
            fieldInfo.SetValue(instancjaObiektu, value);
        }
    }
}
