﻿namespace UMK
{
    using Turing.Model;

    internal class Program
    {
        private static void wyświetlStan(object? sender, Turing.Model.Maszyna.StateChangedEventArgs e) //TODO: oddzielić model od widoku
        {
            //TODO: do poprawnienia
            string stan = e.OpisStanu;
            Console.WriteLine(stan);
            if (e.OstatniaInstrukcja != null) Console.WriteLine("Wykonano instrukcję: " + e.OstatniaInstrukcja);
        }

        private static void wyświetlOstatnieOstrzeżenie(object? sender, EventArgs e)
        {
            string ostatnieOstrzeżenie = (sender as Maszyna).Ostrzeżenia.Last();
            Console.WriteLine("Ostrzeżenie: " + ostatnieOstrzeżenie);
        }

        static void Main(string[] args)
        {
            try
            {
                Console.WriteLine("Maszyna Turinga");
                Maszyna maszynaTuringa = new Maszyna();
                maszynaTuringa.StateChanged += wyświetlStan;
                maszynaTuringa.DodaneOstrzeżenie += wyświetlOstatnieOstrzeżenie;
                maszynaTuringa.WykonajProgram();
            }
            catch(ProgramNieJestPoprawnyException) 
            {
                Console.WriteLine("Program nie jest poprawny");
            }
            catch (StanGłowicyNieJestPoprawnyException)
            {
                Console.WriteLine("Stan maszyny nie jest poprawny");                
            }
            catch (TuringException)
            {
                Console.Error.WriteLine("Inny błąd związany z działaniem maszyny Turingi");
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Inny błąd: " + exc.Message);
            }

            Console.WriteLine("OK.");
        }
    } 
}
