﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Turing.Model
{
    using Czwórka = (char ssg, char szk, char nzk, char nsg); //TODO: pozbyć się Tupli

    #region Zgłaszanie błędów
    class TuringException : Exception { }

    class NieZnalezionoInstrukcjiException : TuringException { }

    class WyjściePozaTaśmęException : TuringException { }

    class ProgramNieJestPoprawnyException : TuringException { }

    class StanGłowicyNieJestPoprawnyException : TuringException { }
    #endregion

    class Maszyna //TODO: refaktoring - nie chcemy boskiej klasy (podział na klasy)
    {
        public List<string> Ostrzeżenia { get; private set; } = new List<string>();

        private void dodajOstrzeżenie(string ostrzeżenie)
        {
            Ostrzeżenia.Add(ostrzeżenie);
            onDodaneOstrzeżenie();
        }


        #region Stan
        private List<char> taśma = new List<char>() { 'A', 'A', 'A', 'B' };

        private char stanGłowicy = 'q'; //qAAAB
        private int pozycjaGłowicy = 0;

        /*
        private List<string> program = new List<string>()
        {
            "qABq", "qBRs", "sAWa", "aALq", "aWLq", "sWLq"
        };
        */

        private List<Czwórka> program = new List<Czwórka>()
        {
            ('q','A','B','q'),
            ('q','B','R','s'),
            ('s','A','W','a'),
            ('a','A','L','q'),
            ('a','W','L','q'),
            ('s','W','L','q')
        };
        #endregion

        #region Nadzór
        private static bool sprawdźPoprawnośćInstrukcji(Czwórka instrukcja) //TODO: włożyć do czwórki
        {
            //TODO: obłożyć testami jednostkowymi            
            if (!char.IsLower(instrukcja.ssg)) return false;
            if (!char.IsUpper(instrukcja.szk)) return false;
            if (!char.IsUpper(instrukcja.nzk)) return false;
            if (!char.IsLower(instrukcja.nsg)) return false;
            return true;
        }

        private static bool sprawdźPoprawnośćProgramu(List<Czwórka> program) //TIP: może osobna klasa programu
        {
            //TODO: obłożyć testami jednostkowymi
            for (int i = 0; i < program.Count; ++i)
            {
                if (!sprawdźPoprawnośćInstrukcji(program[i])) return false;
            }
            return true;
        }

        private bool sprawdźPoprawnośćGłowicy()
        {
            if (!char.IsLower(stanGłowicy)) return false;
            if (pozycjaGłowicy < 0 || pozycjaGłowicy >= taśma.Count) return false;
            return true;
        }
        #endregion

        #region Procesor/Logika
        private Czwórka znajdźOdpowiedniąInstrukcję()
        {
            foreach (Czwórka instrukcja in program)
            {
                if (instrukcja.ssg == stanGłowicy && instrukcja.szk == taśma[pozycjaGłowicy])
                {
                    return instrukcja;
                }
            }
            throw new NieZnalezionoInstrukcjiException();
        }

        private void wykonajInstrukcję(Czwórka instrukcja)
        {
            switch (instrukcja.nzk)
            {
                case 'L':
                    if (pozycjaGłowicy - 1 < 0) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy--;
                    break;
                case 'R':
                    if (pozycjaGłowicy + 1 > taśma.Count - 1) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy++;
                    break;
                default:
                    taśma[pozycjaGłowicy] = instrukcja.nzk;
                    break;
            }
            stanGłowicy = instrukcja.nsg;
        }

        public void WykonajProgram()
        {
            #region Diagnostyka
            if (!sprawdźPoprawnośćProgramu(program))
            {
                throw new ProgramNieJestPoprawnyException();

            }
            if (!sprawdźPoprawnośćGłowicy())
            {
                throw new StanGłowicyNieJestPoprawnyException();
            }
            #endregion

            //TODO: zapamiętać historię stanów !!!!
            //TODO: wykryj zapętlenie i nie pozwól na więcej niż 3 iteracje
            bool czyKontynuować = true;
            //wyświetlStan();
            onStateChanged();
            do
            {
                czyKontynuować = true;
                try
                {
                    Czwórka instrukcja = znajdźOdpowiedniąInstrukcję();
                    //Console.WriteLine("Wykonuję instrukcję: " + instrukcja); //TODO: użyć zdarzeń !!!!
                    wykonajInstrukcję(instrukcja);
                    //wyświetlStan();
                    onStateChanged(instrukcja.ToString());
                }
                catch (NieZnalezionoInstrukcjiException)
                {
                    //Console.Error.WriteLine("Nie znaleziono instrukcji. Koniec programu");
                    dodajOstrzeżenie("Nie znaleziono instrukcji. Koniec programu");
                    czyKontynuować = false;
                }
                catch (WyjściePozaTaśmęException)
                {
                    //Console.Error.WriteLine("Wyjście poza taśmę. Instrukcja nie została wykonana");
                    dodajOstrzeżenie("Wyjście poza taśmę. Instrukcja nie została wykonana");
                }
                catch (TuringException)
                {
                    //Console.Error.WriteLine("Inny błąd związany z działaniem maszyny Turingi");
                    dodajOstrzeżenie("Inny błąd związany z działaniem maszyny Turingi");
                }
                catch (Exception exc)
                {
                    //Console.Error.WriteLine("Inny błąd: " + exc.Message);
                    dodajOstrzeżenie("Inny błąd: " + exc.Message);
                }
            }
            while (czyKontynuować);
            //Console.WriteLine("\n\nOK.");
        }
        #endregion

        public override string ToString()
        {
            return new string(taśma.ToArray()).Insert(pozycjaGłowicy, stanGłowicy.ToString());
        }        

        #region Zdarzenie
        public class StateChangedEventArgs : EventArgs
        {
            public string? OstatniaInstrukcja;
            public string? OpisStanu = null;
        }

        public event EventHandler<StateChangedEventArgs>? StateChanged;

        private void onStateChanged(string? ostatniaInstrukcja = null)
        {
            if (StateChanged != null)
            {
                string stan = this.ToString();
                StateChanged(this, new StateChangedEventArgs() { OpisStanu = stan, OstatniaInstrukcja = ostatniaInstrukcja });
            }
        }

        public event EventHandler? DodaneOstrzeżenie;

        private void onDodaneOstrzeżenie()
        {
            if (DodaneOstrzeżenie != null) DodaneOstrzeżenie(this, EventArgs.Empty);
        }
        #endregion
    }
}
