﻿namespace UMK
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Maszyna Turinga");
            Turing.Maszyna maszynaTuringa = new Turing.Maszyna();
            maszynaTuringa.WykonajProgram();
        }
    } 
}

namespace Turing
{
    using Czwórka = (char ssg, char szk, char nzk, char nsg);

    class TuringException : Exception { }

    class NieZnalezionoInstrukcjiException : TuringException { }

    class WyjściePozaTaśmęException : TuringException { }

    class Maszyna //TODO: refaktoring - nie chcemy boskiej klasy
    {
        #region Stan
        private List<char> taśma = new List<char>() { 'A', 'A', 'A', 'B' };

        private char stanGłowicy = 'q'; //qAAAB
        private int pozycjaGłowicy = 0;

        /*
        private List<string> program = new List<string>()
        {
            "qABq", "qBRs", "sAWa", "aALq", "aWLq", "sWLq"
        };
        */        

        private List<Czwórka> program = new List<Czwórka>()
        {
            ('q','A','B','q'),
            ('q','B','R','s'),
            ('s','A','W','a'),
            ('a','A','L','q'),
            ('a','W','L','q'),
            ('s','W','L','q')
        };

        private void wyświetlStan() //TODO: oddzielić model od widoku
        {
            //TODO: do poprawnienia
            string stan = new string(taśma.ToArray()).Insert(pozycjaGłowicy, stanGłowicy.ToString());
            Console.WriteLine(stan);
        }
        #endregion

        #region Nadzór
        //TODO: weryfikacja poprawności programu, taśmy, głowicy
        /*
        private static bool sprawdźPoprawnośćInstrukcji(string instrukcja)
        {
            //TODO: obłożyć testami jednostkowymi
            if (instrukcja.Length != 4) return false;
            if (!char.IsLower(instrukcja[0])) return false;
            if (!char.IsUpper(instrukcja[1])) return false;
            if (!char.IsUpper(instrukcja[2])) return false;
            if (!char.IsLower(instrukcja[3])) return false;
            return true;
        }
        */

        private static bool sprawdźPoprawnośćInstrukcji(Czwórka instrukcja)
        {
            //TODO: obłożyć testami jednostkowymi            
            if (!char.IsLower(instrukcja.ssg)) return false;
            if (!char.IsUpper(instrukcja.szk)) return false;
            if (!char.IsUpper(instrukcja.nzk)) return false;
            if (!char.IsLower(instrukcja.nsg)) return false;
            return true;
        }

        private static bool sprawdźPoprawnośćProgramu(List<Czwórka> program) //TIP: może osobna klasa programu
        {
            //TODO: obłożyć testami jednostkowymi
            for (int i = 0; i < program.Count; ++i)
            {
                if (!sprawdźPoprawnośćInstrukcji(program[i])) return false;
            }
            return true;
        }

        private bool sprawdźPoprawnośćGłowicy()
        {
            if (!char.IsLower(stanGłowicy)) return false;
            if (pozycjaGłowicy < 0 || pozycjaGłowicy >= taśma.Count) return false;
            return true;
        }
        #endregion

        #region Procesor/Logika
        private Czwórka znajdźOdpowiedniąInstrukcję()
        {
            foreach(Czwórka instrukcja in program)
            {
                if (instrukcja.ssg == stanGłowicy && instrukcja.szk == taśma[pozycjaGłowicy])
                {
                    return instrukcja;
                }
            }
            throw new NieZnalezionoInstrukcjiException();
        }

        /*
        private void wykonajInstrukcję(string instrukcja)
        {            
            switch(instrukcja[2])
            {
                case 'L':
                    if (pozycjaGłowicy - 1 < 0) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy--;
                    break;
                case 'R':
                    if (pozycjaGłowicy + 1 > taśma.Count - 1) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy++;
                    break;
                default:
                    taśma[pozycjaGłowicy] = instrukcja[2];
                    break;
            }
            stanGłowicy = instrukcja[3];
        }
        */

        private void wykonajInstrukcję(Czwórka instrukcja)
        {
            switch (instrukcja.nzk)
            {
                case 'L':
                    if (pozycjaGłowicy - 1 < 0) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy--;
                    break;
                case 'R':
                    if (pozycjaGłowicy + 1 > taśma.Count - 1) throw new WyjściePozaTaśmęException();
                    pozycjaGłowicy++;
                    break;
                default:
                    taśma[pozycjaGłowicy] = instrukcja.nzk;
                    break;
            }
            stanGłowicy = instrukcja.nsg;
        }

        public void WykonajProgram()
        {
            #region Diagnostyka
            if (!sprawdźPoprawnośćProgramu(program))
            {
                Console.WriteLine("Program nie jest poprawny");
                return;
            }
            if (!sprawdźPoprawnośćGłowicy())
            {
                Console.WriteLine("Stan maszyny nie jest poprawny");
                return;
            }
            #endregion

            //TODO: zapamiętać historię stanów !!!!

            //TODO: wykryj zapętlenie i nie pozwól na więcej niż 3 iteracje
            bool czyKontynuować = true;
            wyświetlStan();
            do
            {
                try
                {
                    Czwórka instrukcja = znajdźOdpowiedniąInstrukcję();
                    Console.WriteLine("Wykonuję instrukcję: " + instrukcja); //TODO: użyć zdarzeń
                    wykonajInstrukcję(instrukcja);
                    wyświetlStan();
                }
                catch(NieZnalezionoInstrukcjiException)
                {
                    Console.Error.WriteLine("Nie znaleziono instrukcji. Koniec programu");
                    czyKontynuować = false;
                }
                catch(WyjściePozaTaśmęException)
                {
                    Console.Error.WriteLine("Wyjście poza taśmę. Instrukcja nie została wykonana");
                }
                catch(TuringException)
                {
                    Console.Error.WriteLine("Inny błąd związany z działaniem maszyny Turingi");
                }
                catch(Exception exc)
                {
                    Console.Error.WriteLine("Inny błąd: " + exc.Message);
                }
            }
            while (czyKontynuować);            
            Console.WriteLine("\n\nOK.");
        }
        #endregion
    }
}
