﻿using System.Globalization;
using System.Xml.Schema;
using Turing.Model;

class Program
{
    private static void wyświetlProgram(Turing.Model.Program program)
    {
        Console.WriteLine("Program:");
        foreach(var czwórka in program.Czwórki)
            Console.WriteLine(czwórka.ToString());
    }

    private static void wyświetlStanMaszyny(StanMaszyny stanMaszyny, bool uproszczone = false)
    {
        Console.WriteLine($"Taśma: {stanMaszyny.ToString()}");
        if (!uproszczone)
        {
            Console.WriteLine($"Stan głowicy: {stanMaszyny.StanGłowicy}");
            Console.WriteLine($"Indeks głowicy: {stanMaszyny.IndeksGłowicy}");
        }
    }

    private static void Main(string[] args)
    {
        Console.WriteLine("Turing");

        Turing.Model.Turing maszynaTuringa = null;
        try
        {
            maszynaTuringa = new Turing.Model.Turing("taśma.txt", "program.txt");
            wyświetlStanMaszyny(maszynaTuringa.StanMaszyny);
            wyświetlProgram(maszynaTuringa.Program);
        }
        catch (TuringException exc) 
        {
            Console.Error.WriteLine("Błąd przy próbie inicjacji maszyny Turinga: " + exc.Message);                        
        }
        catch(Exception exc)
        {
            Console.Error.WriteLine("Nierozpoznany typ błędu: " + exc.Message);            
        }

        if (maszynaTuringa == null)
        {
            Console.Error.WriteLine("Nie udało się zainicjować maszyny Turinga");
            Environment.Exit(1);
        }

        //zdarzenie
        maszynaTuringa.InstrukcjaWykonana +=
            (object _sender, Turing.Model.Turing.DaneInstrukcjiEventArgs _e) =>
            {
                Console.WriteLine(_e.WykonywanaInstrukcja.ToString());
                wyświetlStanMaszyny(maszynaTuringa.StanMaszyny, true);
            };

        //wykonywanie programu
        Console.WriteLine("\nUruchamiam program...");
        maszynaTuringa.Uruchom();
        wyświetlStanMaszyny(maszynaTuringa.StanMaszyny);
        Console.WriteLine("Zakończono wykonywanie programu");
    }
}
