﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Turing.Model
{
    public class TuringException : Exception
    {
        public TuringException(string message, Exception innerException)
            : base(message, innerException)
        {
        }
    }

    internal class Turing
    {
        public StanMaszyny StanMaszyny { get; private set; } = null;
        public Program Program { get; private set; } = null;

        public Turing(string ścieżkaPlikuMaszyny = null, string ścieżkaPlikuProgramu = null)
        {
            try
            {
                StanMaszyny = StanMaszyny.Load(ścieżkaPlikuMaszyny);                
            }
            catch (Exception exc)
            {
                throw new TuringException("Błąd przy próbie wczytania taśmy: " + exc.Message, exc);
            }

            try
            {
                Program = Program.Load("program.txt");                
            }
            catch (Exception exc)
            {
                throw new TuringException("Błąd przy próbie wczytania programu: " + exc.Message, exc);
            }
        }

        public void Run()
        {
            InstrukcjaWykonana += (object sender, DaneInstrukcjiEventArgs e) => Console.Write("*");

            (char, char, char, char)? pasującaCzwórka = Program.ZnajdźInstrukcjęDlaStanu(StanMaszyny.StanGłowicy, StanMaszyny.BieżącaWartośćWKomórce);
            while (pasującaCzwórka.HasValue)
            {
                //Console.WriteLine(pasującaCzwórka.Value);
                StanMaszyny.WykonajInstrukcję(pasującaCzwórka.Value);
                gdyInstrukcjaWykonana(pasującaCzwórka.Value);
                pasującaCzwórka = Program.ZnajdźInstrukcjęDlaStanu(StanMaszyny.StanGłowicy, StanMaszyny.BieżącaWartośćWKomórce);
            }            
        }

        //EventHandler<>

        public class DaneInstrukcjiEventArgs : EventArgs
        {
            public (char, char, char, char) WykonywanaInstrukcja;
        }

        public delegate void _InstrukcjaWykonana(object? sender, DaneInstrukcjiEventArgs e);

        public event _InstrukcjaWykonana InstrukcjaWykonana;

        private void gdyInstrukcjaWykonana((char, char, char, char) wykonywanaInstrukcja)
        {
            if (InstrukcjaWykonana != null) InstrukcjaWykonana(this, new DaneInstrukcjiEventArgs() { WykonywanaInstrukcja = wykonywanaInstrukcja });
        }
    }
}
