﻿using System.Globalization;
using System.Xml.Linq;

namespace TEST_Kolory2023
{
    internal static class Ustawienia
    {
        private static string ścieżkaPliku =
            Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "kolory.xml");
        private static IFormatProvider formatProvider = CultureInfo.InvariantCulture;

        public static void Zapisz(double r, double g, double b)
        {
            XDocument xml = new XDocument(
                new XComment($"Zapisano: {DateTime.Now}"),
                new XElement("ustawienia",
                    new XElement("r", r.ToString(formatProvider)),
                    new XElement("g", g.ToString(formatProvider)),
                    new XElement("b", b.ToString(formatProvider))
                )
            );
            xml.Save(ścieżkaPliku);
        }

        public static (double r, double g, double b) Czytaj()
        {
            if (!File.Exists(ścieżkaPliku)) return (0.0, 0.0, 0.0);
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                double r = double.Parse(xml.Root.Element("r").Value, formatProvider);
                double g = double.Parse(xml.Root.Element("g").Value, formatProvider);
                double b = double.Parse(xml.Root.Element("b").Value, formatProvider);
                return (r, g, b);
            }
            catch
            {
                return (0.0, 0.0, 0.0);
            }
        }
    }
}
