﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media.Animation;
using System.Xml.Linq;

namespace LinqToXmlWpf
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            xmlFilePath = System.IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "okno.xml");
            wczytajUstawieniaOkna();
            tbTytułOkna.Text = this.Title;
        }

        private string xmlFilePath;
        private IFormatProvider fp = System.Globalization.CultureInfo.GetCultureInfo("pl-PL");

        private void tbTytułOkna_TextChanged(object sender, TextChangedEventArgs e)
        {            
            this.Title = tbTytułOkna.Text;            
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            //LINQ to XML
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XComment("Zapisano " + DateTime.Now.ToString(fp)),                
                new XElement("okno",
                    new XAttribute("tytuł", this.Title),
                    new XElement("położenie",
                        new XElement("X", this.Left.ToString(fp)),
                        new XElement("Y", this.Top.ToString(fp))
                    ),
                    new XElement("rozmiar",
                        new XElement("W", this.Width.ToString(fp)),
                        new XElement("H", this.Height.ToString(fp))
                    )
                )
            );
            xml.Save(xmlFilePath);
        }

        private void wczytajUstawieniaOkna()
        {
            try
            {
                XDocument xml = XDocument.Load(xmlFilePath);
                string tytułOkna = xml.Root.Attribute("tytuł").Value;
                this.Title = tytułOkna;
                this.Left = double.Parse(xml.Root.Element("położenie").Element("X").Value, fp);
                this.Top = double.Parse(xml.Root.Element("położenie").Element("Y").Value, fp);
                this.Width = double.Parse(xml.Root.Element("rozmiar").Element("W").Value, fp);
                this.Height = double.Parse(xml.Root.Element("rozmiar").Element("H").Value, fp);
            }
            catch 
            {
                this.Title = "Tytuł zastępczy";
                this.Left = 100;
                this.Top = 100;
                this.Width = 800;
                this.Height = 600;
            }
        }

        #region Kursy walut
        private class KursWaluty
        {
            public string NazwaWaluty;
            public string KodWaluty;
            public double KursŚredni;

            public override string ToString()
            {
                return $"{NazwaWaluty} {KodWaluty} - {KursŚredni}";
            }
        }

        private KursWaluty parsujElementPozycja(XElement element)
        {
            if (element.Name != "pozycja") throw new Exception("Niepoprawny typ elementu XML");
            KursWaluty kursWaluty = new KursWaluty()
            {
                NazwaWaluty = element.Element("nazwa_waluty").Value,
                KodWaluty = element.Element("kod_waluty").Value,
                KursŚredni = double.Parse(element.Element("kurs_sredni").Value, fp)
            };
            return kursWaluty;
        }

        private void btnKurstWalut_Click(object sender, RoutedEventArgs e)
        {
            string adres = "https://www.nbp.pl/kursy/xml/LastA.xml";

            //XDocument xml = XDocument.Load(adres); //nie zadziała ze względu na kodowanie pliku

            //pobieranie pliku
            using HttpClient klientSieciowy = new HttpClient();
            using Stream strumień = klientSieciowy.GetStreamAsync(adres).Result;
            string zawartośćPliku = new StreamReader(strumień).ReadToEnd();

            XDocument xml = XDocument.Parse(zawartośćPliku);

            XElement[] elementy = xml.Root.Elements("pozycja").ToArray();

            //bez LINQ            
            List<KursWaluty> kursyWalut = new List<KursWaluty>(elementy.Length);
            foreach(XElement element in elementy ) 
            {
                KursWaluty kursWaluty = parsujElementPozycja(element);
                kursyWalut.Add(kursWaluty);
                lbKursyWalut.Items.Add(kursWaluty.ToString());
            }

            //z LINQ
            //IEnumerable<string> łańcuchy = from XElement element in xml.Root.Elements("pozycja")
            IEnumerable<string> łańcuchy = from XElement element in elementy
                                           let kurs = parsujElementPozycja(element)
                                           where kurs.KursŚredni > 1
                                           select kurs.ToString();
        }
        #endregion
    }
}
