﻿using System.Linq;

class Osoba : ICloneable
//class Osoba
//struct Osoba
//record Osoba
{
    public int Id;
    public string Imię, Nazwisko;
    public int NumerTelefonu, Wiek;

    public override string ToString()
    {
        return $"{Id}. {Imię} {Nazwisko}, tel. {NumerTelefonu}";
    }

    public object Clone()
    {
        return new Osoba() { Id = this.Id, Imię = this.Imię, Nazwisko = this.Nazwisko, NumerTelefonu= this.NumerTelefonu, Wiek = this.Wiek };
    }

    public Osoba Klonuj()
    {
        return (Osoba)Clone();
        //return this;
    }
}

static class RozszerzeniaLinq
{
    public static T Variance<T>(this IEnumerable<T> liczby)        
        where T : System.Numerics.INumber<T>        
    {
        if(liczby == null) throw new ArgumentNullException(nameof(liczby));

        T średnia = default(T);
        T liczebność = default(T);
        foreach (T liczba in liczby)
        {
            średnia += liczba;
            liczebność++;
        }
        średnia /= liczebność;
        
        T odchylenie = default(T);
        foreach (T liczba in liczby)
        {
            T d = liczba - średnia;
            odchylenie += d * d;
        }
        return odchylenie / liczebność;
        
        //return Math.Sqrt(odchylenie / liczby.Count());
    }

    public static double StdDevDouble(this IEnumerable<double> liczby)    
    {
        double średnia = liczby.Average();
        double odchylenie = 0;
        foreach(double liczba in liczby)
        {
            double d = liczba - średnia;
            odchylenie += d * d;
        }
        return Math.Sqrt(odchylenie / liczby.Count());
    }
}

class Program
{
    private static List<Osoba> listaOsób = new List<Osoba>()
    {
        new Osoba() {Id = 1, Imię = "Jacek", Nazwisko="Matulewski", NumerTelefonu=394878, Wiek=10},
        new Osoba() {Id = 2, Imię = "Henryk", Nazwisko="Talar", NumerTelefonu=87389237, Wiek=51},
        new Osoba() {Id = 3, Imię = "Mieszko", Nazwisko="Pierwszy", Wiek=52},
        new Osoba() {Id = 4, Imię = "Bolesław", Nazwisko="Chrobry", NumerTelefonu=980980, Wiek=53},
        new Osoba() {Id = 5, Imię = "Jadwiga", Nazwisko="Jagiełło", NumerTelefonu=873984, Wiek=14},
    };

    private static void wyświetlListęOsób(IEnumerable<Osoba> osoby)
    {
        Console.WriteLine("Lista osób:");
        foreach (Osoba osoba in osoby)
        {
            Console.WriteLine(osoba.ToString());
        }
    }    

    private static void wyświetlListęElementów<T>(IEnumerable<T> elementy)
        where T : struct
    {
        Console.WriteLine("Lista elementów:");
        foreach (T element in elementy)
        {
            Console.WriteLine(element.ToString());
        }
    }

    public static void Main(string[] args)
    {
        //wyświetlListęOsób(listaOsób);

        /*
        var listaOsóbPełnoletnich = from Osoba osoba in listaOsób
                                    where osoba.Wiek >= 18
                                    orderby osoba.Wiek descending
                                    select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
        wyświetlListęElementów(listaOsóbPełnoletnich);
        */

        Console.WriteLine("1");
        //var listaOsóbPełnoletnich = from Osoba osoba in listaOsób
        //                            where osoba.Wiek >= 18
        //                            orderby osoba.Wiek descending
        //                            select osoba.Klonuj();
        //                            //select new Osoba { Id = osoba.Id, Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, NumerTelefonu = osoba.NumerTelefonu, Wiek = osoba.Wiek };                                    
        //var listaOsóbPełnoletnich = new List<Osoba> { listaOsób[1], listaOsób[2], listaOsób[3] };

        var listaOsóbPełnoletnich = listaOsób.Where(o => o.Wiek >= 18).OrderBy(o => o.Wiek).Select(o => o.Klonuj());

        wyświetlListęOsób(listaOsób);
        wyświetlListęOsób(listaOsóbPełnoletnich);

        Console.WriteLine("2");
        //listaOsóbPełnoletnich.ElementAt(1).Imię = "Harry";
        //listaOsóbPełnoletnich.ElementAt(1).Nazwisko = "Potter";

        Osoba[] listaOsóbPełnoletnich1 = listaOsóbPełnoletnich.ToArray();
        listaOsóbPełnoletnich1[1].Imię = "Harry";
        listaOsóbPełnoletnich1[1].Nazwisko = "Potter";

        wyświetlListęOsób(listaOsób);
        wyświetlListęOsób(listaOsóbPełnoletnich);
        wyświetlListęOsób(listaOsóbPełnoletnich1);

        Console.WriteLine("3");
        Console.WriteLine(listaOsób.Max(o => o.Wiek));
        Console.WriteLine(listaOsób.Average(o => o.Wiek));
        Console.WriteLine(listaOsób.Min(o => o.Wiek));
        Console.WriteLine(listaOsób.Sum(o => o.Wiek));

        Console.WriteLine(listaOsób.Single(o => o.Wiek == 10));
        Console.WriteLine(listaOsób.First(o => o.Wiek < 18));
        Console.WriteLine(listaOsób.FirstOrDefault(o => o.Wiek < 10, new Osoba { Id = -1 }));

        bool czyWszyscyPełnoletni = listaOsób.All(o => o.Wiek >= 18);
        Console.WriteLine(czyWszyscyPełnoletni);

        bool czyWszyscyPełnoletni1 = listaOsóbPełnoletnich.All(o => o.Wiek >= 18);
        Console.WriteLine(czyWszyscyPełnoletni1);

        bool czyJakikolwiekNiepełnoletni = listaOsób.Any(o => o.Wiek < 18);
        Console.WriteLine(czyJakikolwiekNiepełnoletni);

        //IEnumerable<double> wieki = listaOsób.Select(o => (double)o.Wiek);
        var wieki = listaOsób.Select(o => (double)o.Wiek);
        double odchylenie = wieki.StdDevDouble();
        Console.WriteLine(odchylenie);

        double odchylenie1 = Math.Sqrt(wieki.Variance());
        Console.WriteLine(odchylenie1);
    }
}



