﻿using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;

namespace Excel
{
    public class Dokument
    {
        public void StwórzDokumentExcel(string nazwaPliku)
        {
            using (SpreadsheetDocument dokument = SpreadsheetDocument.Create(nazwaPliku, SpreadsheetDocumentType.Workbook))
            {
                WorkbookPart częśćZeszytu = dokument.AddWorkbookPart();
                częśćZeszytu.Workbook = new Workbook();


                WorksheetPart częśćArkusza = częśćZeszytu.AddNewPart<WorksheetPart>();
                częśćArkusza.Worksheet = new Worksheet();

                WorkbookStylesPart częśćStylów = częśćZeszytu.AddNewPart<WorkbookStylesPart>();
                częśćStylów.Stylesheet = GenerujStylArkusza();
                częśćStylów.Stylesheet.Save();

                Columns kolumny = new Columns(
                    new Column { Min = 1, Max = 1, Width = 40, CustomWidth = true },
                    new Column { Min = 2, Max = 2, Width = 30, CustomWidth = true },
                    new Column { Min = 3, Max = 3, Width = 15, CustomWidth = true }

                    );
                częśćArkusza.Worksheet.AppendChild(kolumny);

                Sheets arkusze = częśćZeszytu.Workbook.AppendChild(new Sheets());

                Sheet arkusz = new Sheet() { Id = częśćZeszytu.GetIdOfPart(częśćArkusza), SheetId = 1, Name = "Arkusz 1" };
                arkusze.Append(arkusz);

                częśćZeszytu.Workbook.Save();
                ZapisDoExcela(częśćArkusza);

            }

        }

        private static void ZapisDoExcela(WorksheetPart częśćArkusza)
        {
            SheetData dane = częśćArkusza.Worksheet.AppendChild(new SheetData());
            Row wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Imię i nazwisko"), DataType = CellValues.String, StyleIndex = 2 },
                new Cell() { CellValue = new CellValue("Miasto"), DataType = CellValues.String, StyleIndex = 2 },
                new Cell() { CellValue = new CellValue("Ulica"), DataType = CellValues.String, StyleIndex = 2 });
            dane.AppendChild(wiersz);

            wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Adam Nowak"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Warszawa"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Kwiatowa"), DataType = CellValues.String, StyleIndex = 1 });
            dane.AppendChild(wiersz);

            wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Bartek Kowalski"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Kraków"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Polna"), DataType = CellValues.String, StyleIndex = 1 });
            dane.AppendChild(wiersz);

            wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Dorota Kowalczyk"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Toruń"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Fabryczna"), DataType = CellValues.String, StyleIndex = 1 });
            dane.AppendChild(wiersz);

            wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Ewelina Karczewska "), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Poznań"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Długa"), DataType = CellValues.String, StyleIndex = 1 });
            dane.AppendChild(wiersz);

            wiersz = new Row();
            wiersz.Append(
                new Cell() { CellValue = new CellValue("Barbara Kloniecka"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Szczecin"), DataType = CellValues.String, StyleIndex = 1 },
                new Cell() { CellValue = new CellValue("Kolejowa"), DataType = CellValues.String, StyleIndex = 1 });
            dane.AppendChild(wiersz);

            częśćArkusza.Worksheet.Save();
        }

        private Stylesheet GenerujStylArkusza()
        {
            Stylesheet stylArkusza = null;

            Fonts czcionki = new Fonts(
                new Font(new FontSize() { Val = 10 }),
                new Font(new FontSize() { Val = 20 }, new Bold(), new Color() { Rgb = "FFFFFF" })
                );

            Fills wypełnienia = new Fills(
                new Fill(new PatternFill() { PatternType = PatternValues.None }),
                new Fill(new PatternFill() { PatternType = PatternValues.Gray125 }),
                new Fill(new PatternFill(new ForegroundColor { Rgb = new HexBinaryValue() { Value = "009900" } }) { PatternType = PatternValues.Solid} ),
                new Fill(new PatternFill(new ForegroundColor { Rgb = new HexBinaryValue() { Value = "33FF99" } }) { PatternType = PatternValues.Solid })

                );

            Borders ramki = new Borders(
                new Border(),
                new Border(
                    new LeftBorder(new Color() { Auto = true }) { Style = BorderStyleValues.Thin},
                    new RightBorder(new Color() { Auto = true }) { Style = BorderStyleValues.Thin},
                    new TopBorder(new Color() { Auto = true }) { Style = BorderStyleValues.Thin},
                    new BottomBorder(new Color() { Auto = true }) { Style = BorderStyleValues.Thin},
                    new DiagonalBorder())

                );


            CellFormats formatowaneKomórki = new CellFormats(
                new CellFormat(),
                new CellFormat { FontId = 0, FillId = 3, BorderId =1, ApplyBorder=true},
                new CellFormat { FontId = 1, FillId = 2, BorderId = 1, ApplyBorder=true }

                );

            stylArkusza = new Stylesheet(czcionki, wypełnienia, ramki, formatowaneKomórki);

            return stylArkusza;
        }



    }
}
