﻿using System.Globalization;
using System.Xml.Linq;

namespace KoloryMAUI2023.Model
{
    public static class Ustawienia
    {
        private static string ścieżkaPliku = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "kolory.xml");
        private static IFormatProvider fp = new CultureInfo("pl-PL");

        public static void Zapisz(Kolor model)
        {
            XDocument xml = new XDocument(
                new XElement("ustawienia",
                    new XElement("R", model.R.ToString(fp)),
                    new XElement("G", model.G.ToString(fp)),
                    new XElement("B", model.B.ToString(fp))));
            xml.Save(ścieżkaPliku);
        }

        public static Kolor Wczytaj()
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                string sr = xml.Root.Element("R").Value;
                string sg = xml.Root.Element("G").Value;
                string sb = xml.Root.Element("B").Value;
                double r = double.Parse(sr, fp);
                double g = double.Parse(sg, fp);
                double b = double.Parse(sb, fp);
                return new Kolor() { R = r, G = g, B = b };
            }
            catch
            {
                return Kolor.Czerń;
            }
        }
    }
}
