﻿using System;
using System.Collections.Generic;
using System.Globalization;
namespace KoloryMAUI2023
{
    internal class DoubleToString : IValueConverter
    {
        private string colorComponentToString(double value)
        {
            return Math.Round(255.0 * value).ToString();
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double d = (double)value;
            return colorComponentToString(d);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    internal class RGBToColor : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            if (values == null || values.Any(v => v == null)) return Colors.Black;
            double r = (double)values[0];
            double g = (double)values[1];
            double b = (double)values[2];
            return Color.FromRgb(r, g, b);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
