﻿using KoloryMAUI2023.Model;
using System.ComponentModel;
using System.Windows.Input;

namespace KoloryMAUI2023.ModelWidoku
{
    internal class KolorMW : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.Ustawienia.Wczytaj();

        public double R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R));
                Ustawienia.Zapisz(model);
            }
        }

        public double G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G));
                Ustawienia.Zapisz(model);
            }
        }

        public double B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B));
                Ustawienia.Zapisz(model);
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged != null) 
                foreach(string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null)
                    resetuj = new Command(
                        () => { R = 0; G = 0; B = 0; },
                        () => R != 0 || G != 0 || B != 0
                    );
                return resetuj;
            }
        }
    }
}
