﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Serializacja.Model
{
    public struct Rozmiar
    {
        public int Szerokość, Wysokość;

        public override string ToString()
        {
            return $"{Szerokość} x {Wysokość}";
        }
    }

    public class UstawieniaKonsoli : ICloneable
    {
        public ConsoleColor KolorTła, KolorCzcionki;
        public Rozmiar RozmiarOkna, RozmiarBufora;
        public string Tytuł;

        public override string ToString()
        {
            string s = "";
            s += Tytuł;
            return s;
        }

        public object Clone()
        {
            return new UstawieniaKonsoli()
            {
                KolorTła = this.KolorTła,
                KolorCzcionki = this.KolorCzcionki,
                RozmiarOkna = this.RozmiarOkna,
                RozmiarBufora = this.RozmiarBufora,
                Tytuł = this.Tytuł
            };
        }
    }
}
