﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Serializacja.Kontroler
{
    using static Wejście;
    using Model;

    public class Menu
    {
        private static void wyświetlMenu()
        {
            string s = "\nMenu:";
            s += "\n1. Przywróć ustawienia domyślna";
            s += "\n2. Zmień kolor tła";
            s += "\n3. Zmień kolor czcionki";
            s += "\n4. Zmień rozmiar okna";
            s += "\n5. Zmień rozmiar bufora";
            s += "\n6. Zmień tytuł okna";
            s += "\n0. Zakończ program";
            Console.WriteLine(s);
        }

        public void Uruchom()
        {
            int wybór = 0;
            do
            {
                wyświetlMenu();
                wybór = PobierzOdUżytkownikaLiczbęCałkowitą("Wybierz pozycję menu: ", 6);
                switch (wybór)
                {
                    case 1:
                        ustawienia = PomocnikUstawieńKonsoli.UstawieniaDomyślne;
                        break;
                    case 2:
                        ConsoleColor kolorTła = PobierzOdUżytkownikaKolor(
                            "Podaj kolor tła (po angielsku): ");
                        ustawienia.KolorTła = kolorTła;
                        break;
                    case 3:
                        ConsoleColor kolorCzcionki = PobierzOdUżytkownikaKolor(
                            "Podaj kolor czcionki (po angielsku): ");
                        ustawienia.KolorCzcionki = kolorCzcionki;
                        break;
                    case 4:
                        {
                            int x = PobierzOdUżytkownikaLiczbęCałkowitą("Podaj szerokość okna: ", Console.LargestWindowWidth);
                            int y = PobierzOdUżytkownikaLiczbęCałkowitą("Podaj wysokość okna: ", Console.LargestWindowHeight);
                            Rozmiar rozmiar = new Rozmiar()
                            {
                                Szerokość = x,
                                Wysokość = y
                            };
                            ustawienia.RozmiarOkna = rozmiar;
                        }
                        break;
                    case 5:
                        {
                            int x = PobierzOdUżytkownikaLiczbęCałkowitą("Podaj szerokość bufora: ", Console.LargestWindowWidth);
                            int y = PobierzOdUżytkownikaLiczbęCałkowitą("Podaj wysokość bufora: ", Console.LargestWindowHeight);
                            Rozmiar rozmiar = new Rozmiar()
                            {
                                Szerokość = x,
                                Wysokość = y
                            };
                            ustawienia.RozmiarBufora = rozmiar;
                        }
                        break;
                    case 6:
                        Console.WriteLine("Podaj tytuł okna: ");
                        string tytuł = Console.ReadLine();
                        ustawienia.Tytuł = tytuł;
                        break;
                }
                spróbujZastosowaćUstawienia();
            }
            while (wybór != 0);
        }

        private UstawieniaKonsoli ustawienia, poprzednieUstawienia = PomocnikUstawieńKonsoli.UstawieniaBieżące;

        private void spróbujZastosowaćUstawienia()
        {
            if (Widok.Widok.ZastosujUstawienia(ustawienia))
            {
                poprzednieUstawienia = (UstawieniaKonsoli)ustawienia.Clone();
            }
            else
            {
                Console.WriteLine("Przywracam poprzednie ustawienia");
                Widok.Widok.ZastosujUstawienia(poprzednieUstawienia);
            }
        }

        public Menu(UstawieniaKonsoli ustawienia)
        {
            this.ustawienia = ustawienia;
            spróbujZastosowaćUstawienia();
        }
    }
}
