﻿using EF;

public class Program
{
    static void podglądBazyDanych(BazaDanychOsób db)
    {
        try
        {
            Console.WriteLine("\nPodgląd danych:");
            Console.WriteLine("Osoby:");
            foreach (Osoba osoba in db.Osoby)
                Console.WriteLine(osoba);
            Console.WriteLine("Adresy:");
            foreach (Adres adres in db.Adresy)
                Console.WriteLine(adres);
        }
        catch(Exception exc) 
        {
            Console.Error.WriteLine("Błąd podglądu bazy danych: " + exc.Message);
        }
    }

    static void dodajPrzykładoweOsoby(BazaDanychOsób db)
    {
        Adres adres1 = new Adres()
        {
            Miasto = "Toruń",
            Ulica = "Pod Mostem",
            NumerDomu = 1
        };
        Adres adres2 = new Adres()
        {
            Miasto = "Toruń",
            Ulica = "Gałczyńskiego",
            NumerDomu = 5,
            NumerMieszkania = 34
        };

        Osoba osoba1 = new Osoba()
        {
            Imię = "Antoni",
            Nazwisko = "Gburek",
            NumerTelefonu = 1234567,
            Adres = adres1
        };
        Osoba osoba2 = new Osoba()
        {
            Imię = "Karol",
            Nazwisko = "Gacek",
            NumerTelefonu = 98876990,
            Adres = adres2
        };
        Osoba osoba3 = new Osoba()
        {
            Imię = "Wincenty",
            Nazwisko = "Patyk",
            NumerTelefonu = 234639875,
            Adres = adres1
        };

        db.DodajOsobę(osoba1);
        db.DodajOsobę(osoba2);
        db.DodajOsobę(osoba3);
    }

    static void pokażIndentyfikatoryOsób(BazaDanychOsób db)
    {
        string s = "Identyfikatory osób: ";
        foreach (int idOsoby in db.IdentyfikatoryOsób)
            s += idOsoby.ToString() + "; ";
        Console.WriteLine(s.Trim(' ', ';'));
    }

    static void pokażOsoby(BazaDanychOsób db)
    {
        foreach (int idOsoby in db.IdentyfikatoryOsób)
            Console.WriteLine(db[idOsoby].ToString());
    }

    public static void Main()
    {
        Console.WriteLine("Usuwam pliki bazy danych...");
        string dbName = "osoby.db";
        if (File.Exists(dbName)) File.Delete(dbName);

        BazaDanychOsób db = new BazaDanychOsób();

        Console.WriteLine("Dodaję przykładowe osoby...");
        dodajPrzykładoweOsoby(db);
        pokażIndentyfikatoryOsób(db);
        podglądBazyDanych(db);

        Console.WriteLine("Osoby:");
        pokażOsoby(db);

        int idUsuwanejOsoby = 2;
        Console.WriteLine($"\nUsuwam osobę nr {idUsuwanejOsoby}...");
        db.UsuńOsobę(idUsuwanejOsoby);
        podglądBazyDanych(db);

        Console.Write("\nZmieniam dane osoby nr 1...");
        //db.ZmieńDaneOsoby(1, new Osoba() { Imię = "Henryk", Nazwisko = "Garncarz", Adres = new Adres() { Miasto = "Toruń", Ulica = "Mostowa", NumerDomu = 2, NumerMieszkania = 13 } });
        db[1] = new Osoba() { Imię = "Henryk", Nazwisko = "Garncarz", Adres = new Adres() { Miasto = "Toruń", Ulica = "Mostowa", NumerDomu = 2, NumerMieszkania = 13 } };
        podglądBazyDanych(db);
    }
}
