﻿using System.Globalization;
using System.Xml.Linq;

namespace KoloryMAUI2023
{
    public static class Ustawienia
    {
        private static string ścieżkaPliku = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "kolory.xml");
        private static IFormatProvider fp = new CultureInfo("pl-PL");

        public static void Zapisz(double r, double g, double b)
        {
            XDocument xml = new XDocument(
                new XElement("ustawienia",
                    new XElement("R", r.ToString(fp)),
                    new XElement("G", g.ToString(fp)),
                    new XElement("B", b.ToString(fp))));
            xml.Save(ścieżkaPliku);
        }

        public static (double R, double G, double B) Wczytaj()
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                string sr = xml.Root.Element("R").Value;
                string sg = xml.Root.Element("G").Value;
                string sb = xml.Root.Element("B").Value;
                double r = double.Parse(sr, fp);
                double g = double.Parse(sg, fp);
                double b = double.Parse(sb, fp);
                return (r, g, b);
            }
            catch
            {
                return (0.0, 0.0, 0.0);
            }
        }
    }
}
