﻿namespace KoloryMAUI2023;

public partial class MainPage : ContentPage
{
	public MainPage()
	{
		InitializeComponent();
		var kolor = Ustawienia.Wczytaj();
		wstrzymajZmianyInterfejsu = true;
		sliderR.Value = kolor.R;
		sliderG.Value = kolor.G;
		wstrzymajZmianyInterfejsu = false;
		sliderB.Value = kolor.B;
	}

	private string colorComponentToString(double value)
	{
		return Math.Round(value).ToString();
	}

	private bool wstrzymajZmianyInterfejsu = false;

    private void slider_ValueChanged(object sender, ValueChangedEventArgs e)
    {
		if (wstrzymajZmianyInterfejsu) return;
		Color kolor = Color.FromRgb(sliderR.Value, sliderG.Value, sliderB.Value);
		rectangle.Background = new SolidColorBrush(kolor);
		//GC.Collect();
		labelR.Text = colorComponentToString(kolor.Red * 255f);
        labelG.Text = colorComponentToString(kolor.Green * 255f);
        labelB.Text = colorComponentToString(kolor.Blue * 255f);
    }

    private void Button_Clicked(object sender, EventArgs e)
    {
		wstrzymajZmianyInterfejsu = true;
		sliderR.Value = 0;
        sliderG.Value = 0;
		wstrzymajZmianyInterfejsu = false;
        sliderB.Value = 0;
    }

    private void ContentPage_Disappearing(object sender, EventArgs e)
    {
		Ustawienia.Zapisz(sliderR.Value, sliderG.Value, sliderB.Value);
    }
}

