﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Serializacja.Model
{
    class PomocnikUstawieńKonsoli
    {
        public static UstawieniaKonsoli UstawieniaBieżące
        {
            get
            {
                return new UstawieniaKonsoli()
                {
                    KolorTła = Console.BackgroundColor,
                    KolorCzcionki = Console.ForegroundColor,
                    RozmiarOkna = new Rozmiar()
                    {
                        Szerokość = Console.WindowWidth,
                        Wysokość = Console.WindowHeight,
                    },
                    RozmiarBufora = new Rozmiar()
                    {
                        Szerokość = Console.BufferWidth,
                        Wysokość = Console.BufferHeight
                    }
                };
            }
        }

        public static UstawieniaKonsoli UstawieniaDomyślne
        {
            get =>
                new UstawieniaKonsoli()
                {
                    KolorTła = ConsoleColor.Black,
                    KolorCzcionki = ConsoleColor.Gray,
                    RozmiarOkna = { Szerokość = 120, Wysokość = 30 },
                    RozmiarBufora = { Szerokość = 120, Wysokość = 900 },
                    Tytuł = System.Reflection.Assembly.GetEntryAssembly().Location
                };
        }
    }
}
