﻿using System;

namespace OpenXML_Word
{
    using DocumentFormat.OpenXml;
    using DocumentFormat.OpenXml.Wordprocessing;

    public static class FormatowaniaDocx
    {
        private const int rozmiarCzcionkiNormalny = 21;
        private const int rozmiarCzcionkiTytułu = 48;
        private const string kształtCzcionki = "Arial";

        public static Color KolorWyróżniony
        {
            get
            {
                return new Color() { Val = "203A8F" };
            }
        }

        public static Color KolorNormalny
        {
            get
            {
                return new Color() { Val = "black" };
            }
        }

        public static RunFonts CzcionkaNormalna
        {
            get
            {
                return new RunFonts()
                {
                    Ascii = kształtCzcionki,
                    HighAnsi = kształtCzcionki
                };
            }
        }

        public static RunProperties StylUstępuNormalny
        {
            get
            {
                return new RunProperties()
                {
                    RunFonts = CzcionkaNormalna,
                    FontSize = new FontSize()
                    {
                        Val = new StringValue(rozmiarCzcionkiNormalny.ToString())
                    },
                    Color = KolorNormalny
                };
            }
        }

        public static RunProperties StylUstępuWyróżniony
        {
            get
            {
                return new RunProperties()
                {
                    Bold = new Bold()
                    {
                        Val = OnOffValue.FromBoolean(true),
                    },
                    RunFonts = CzcionkaNormalna,
                    FontSize = new FontSize()
                    {
                        Val = new StringValue(rozmiarCzcionkiTytułu.ToString())
                    },
                    Color = KolorWyróżniony
                };
            }
        }

        public static ParagraphProperties UstawieniaAkapituZwiększonaInterlinia
        {
            get
            {
                ParagraphProperties paragraphProperties = new ParagraphProperties();
                paragraphProperties.Append(
                    new SpacingBetweenLines() { Line = "360" });
                return paragraphProperties;
            }
        }
    }
}
