﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EF
{
    public class Osoba
    {
        [Key] public int Id { get; set; } //primary key
        public string Imię { get; set; }
        public string Nazwisko { get; set; }
        public int? NumerTelefonu { get; set; }

        public Adres Adres { get; set; }

        public override bool Equals(object? obj)
        {
            if (obj is not Osoba) return false;
            Osoba innaOsoba = obj as Osoba;
            return
                Id == innaOsoba.Id &&
                Imię.Equals(innaOsoba.Imię) &&
                Nazwisko.Equals(innaOsoba.Nazwisko);
        }

        public override string ToString()
        {
            return $"({Id}) {Imię} {Nazwisko} ({(NumerTelefonu.HasValue ? NumerTelefonu.Value.ToString() : "---")}), {Adres}";
        }
    }

    public class Adres
    {
        [Key] public int Id { get; set; }
        public string Miasto { get; set; }
        public string Ulica { get; set; }
        public int NumerDomu { get; set; }
        public int? NumerMieszkania { get; set; }

        public override string ToString()
        {
            return $"({Id}) {Miasto}, {Ulica} {NumerDomu}/{NumerMieszkania}".TrimEnd('/');
        }
    }
}
