﻿using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;
using System;
using System.Globalization;
using System.IO;
using System.Reflection;

namespace OpenXML_Word
{
    using static FormatowaniaDocx;

    public class Dane
    {
        public string[] Linie =
        {
                "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",
                "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
                "Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.",
                "Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."
            };
    }

    public static class PomocnikDocx
    {
        private static Paragraph twórzAkapit(string[] linie, int rozmiarCzcionki, Color kolorCzcionki)
        {
            Paragraph akapit = new Paragraph();
            akapit.Append(UstawieniaAkapituZwiększonaInterlinia);
            Run ustęp = akapit.AppendChild(new Run());
            RunProperties stylAkapitu = StylUstępuNormalny;
            stylAkapitu.FontSize.Val = new StringValue(rozmiarCzcionki.ToString());
            stylAkapitu.Color = kolorCzcionki;
            ustęp.Append(stylAkapitu);
            foreach (string linia in linie)
            {
                ustęp.AppendChild(new Text(linia));
                ustęp.AppendChild(new Break());
            }
            return akapit;
        }

        private static Paragraph twórzAkapit(Drawing rysunek)
        {
            return new Paragraph(new Run(rysunek));
        }

        private static Paragraph twórzAkapitTytułu(string tytuł)
        {
            Paragraph akapitTytułu = new Paragraph();
            Run ustępTytułu = akapitTytułu.AppendChild(new Run());
            ustępTytułu.Append(StylUstępuWyróżniony);
            ustępTytułu.AppendChild(new Text(tytuł));
            return akapitTytułu;
        }

        private static Stream pobierzRysunekZZasobów(string nazwaZasobu)
        {
            Assembly assembly = typeof(PomocnikDocx).GetTypeInfo().Assembly;
            Stream strumień = assembly.GetManifestResourceStream(nazwaZasobu);
            return strumień;
        }

        private static Stream pobierzRysunekZPliku(string ścieżkaPliku)
        {
            Stream strumień = new FileStream(ścieżkaPliku, FileMode.Open);
            return strumień;
        }

        private static Drawing twórzRysunekWDokumencie(WordprocessingDocument dokumentWorda, Stream strumień)
        {
            MainDocumentPart częśćGłówna = dokumentWorda.MainDocumentPart;
            ImagePart częśćRysunku = częśćGłówna.AddImagePart(ImagePartType.Png);
            częśćRysunku.FeedData(strumień);
            return RysunekDocx.CreateDrawingElement(
                dokumentWorda, 
                częśćGłówna.GetIdOfPart(częśćRysunku),
                2.5f, 1);
        }

        private static Table twórzTabelę(string[,] komórki, string[] komórkiNagłówka = null)
        {
            if (komórkiNagłówka != null && komórkiNagłówka.Length != komórki.GetLength(0))
                throw new Exception("Nieprawidłowa liczba elementów nagłówka");

            Table tabela = new Table(); //pusta tabela

            uint grubośćZewnętrznejLinii = 10;
            uint grubośćWewnętrznejLinii = 2;

            TableProperties własnościTabeli = new TableProperties(
                new TableBorders(
                    new TopBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćZewnętrznejLinii
                    },
                    new BottomBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćZewnętrznejLinii
                    },
                    new LeftBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćZewnętrznejLinii
                    },
                    new RightBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćZewnętrznejLinii
                    },
                    new InsideHorizontalBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćWewnętrznejLinii
                    },
                    new InsideVerticalBorder()
                    {
                        Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines),
                        Size = grubośćWewnętrznejLinii
                    }));
            tabela.AppendChild(własnościTabeli);

            TableRow wierszNagłówka = new TableRow();
            for (int kolumna = 0; kolumna < komórkiNagłówka.Length; kolumna++)
            {
                TableCell komórkaTabeli = new TableCell();
                komórkaTabeli.Append(
                    new TableCellProperties(
                        new TableCellWidth()
                        {
                            Type = TableWidthUnitValues.Dxa,
                            Width = "2400"
                        }
                    ));

                Run ustępKomókiTabeli = new Run(new Text(komórkiNagłówka[kolumna]));
                ustępKomókiTabeli.RunProperties = new RunProperties()
                {
                    Bold = new Bold() { Val = OnOffValue.FromBoolean(true) },
                    Color = KolorWyróżniony
                };
                komórkaTabeli.Append(new Paragraph(ustępKomókiTabeli));
                wierszNagłówka.Append(komórkaTabeli);
            }
            return tabela;
        }

        private static void wyślijDokumentDoStrumienia(Dane dane, Stream stream, IFormatProvider formatProvider)
        {
            using (WordprocessingDocument dokumentWorda = WordprocessingDocument.Create(
                stream, WordprocessingDocumentType.Document, true))
            {
                MainDocumentPart głównaCzęśćDokumentu = dokumentWorda.AddMainDocumentPart();
                głównaCzęśćDokumentu.Document = new Document();

                Body ciałoDokumentu = new Body();
                głównaCzęśćDokumentu.Document.AppendChild(ciałoDokumentu);

                //logo
                Stream strumieńRysunku = pobierzRysunekZZasobów("OpenXML_Word.rysunki.umk.png");
                //Stream strumieńRysunku = pobierzRysunekZPliku(@"c:\Users\pk\source\repos\OpenXML\OpenXML\bin\Debug\netcoreapp3.1\rysunki\umk.png");
                Drawing rysunek = twórzRysunekWDokumencie(dokumentWorda, strumieńRysunku);
                Paragraph akapitRysunku = twórzAkapit(rysunek);
                ciałoDokumentu.AppendChild(akapitRysunku);

                //nagłówek
                string[] linieNagłówka = new string[]
                {
                    "e-mail: biuro@firma.pl",
                    "www.firma.pl",
                    "tel: +48 829131 12398123, wewn. 21",
                    "fax: +48 82 21738 172872"
                };
                Paragraph akapitNagłówka = twórzAkapit(linieNagłówka, 18, KolorWyróżniony);
                ciałoDokumentu.AppendChild(akapitNagłówka);

                //tytuł
                ciałoDokumentu.AppendChild(twórzAkapitTytułu("Lorem Ipsum"));

                string[] linie = dane.Linie;
                Paragraph akapit = twórzAkapit(linie, 25, KolorNormalny);
                ciałoDokumentu.AppendChild(akapit);

                string[,] komórki = new string[2, 2]
                {
                    {"1","2"},
                    {"3","4"}
                };
                Table tabela = twórzTabelę(komórki, new string[2] { "A", "B" });
                ciałoDokumentu.Append(tabela);
                ----> dodać pozostałe komórki, nie widać w dokumencie

                dokumentWorda.Close();
            }
            stream.Flush();
        }

        public static void EksportujDoPlikuDocx(this Dane dane, string ścieżkaPliku, IFormatProvider formatProvider = null)
        {
            if (formatProvider == null) formatProvider = new CultureInfo("pl-PL");
            if (File.Exists(ścieżkaPliku)) File.Delete(ścieżkaPliku);
            using (FileStream strumieńPliku = new FileStream(ścieżkaPliku, FileMode.CreateNew))
            {
                wyślijDokumentDoStrumienia(dane, strumieńPliku, formatProvider);
                strumieńPliku.Close();
            }
        }
    }
}
