﻿using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;
using System;
using System.Globalization;
using System.IO;

namespace OpenXML_Word
{
    using static FormatowaniaDocx;

    public class Dane
    {
        public string[] Linie =
        {
                "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",
                "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
                "Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.",
                "Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."
            };
    }

    public static class PomocnikDocx
    {
        private static Paragraph twórzAkapit(string[] linie, int rozmiarCzcionki, Color kolorCzcionki)
        {
            Paragraph akapit = new Paragraph();
            akapit.Append(UstawieniaAkapituZwiększonaInterlinia);
            Run ustęp = akapit.AppendChild(new Run());
            RunProperties stylAkapitu = StylUstępuNormalny;
            stylAkapitu.FontSize.Val = new StringValue(rozmiarCzcionki.ToString());
            stylAkapitu.Color = kolorCzcionki;
            ustęp.Append(stylAkapitu);
            foreach (string linia in linie)
            {
                ustęp.AppendChild(new Text(linia));
                ustęp.AppendChild(new Break());
            }
            return akapit;
        }

        private static void wyślijDokumentDoStrumienia(Dane dane, Stream stream, IFormatProvider formatProvider)
        {
            using (WordprocessingDocument dokumentWorda = WordprocessingDocument.Create(
                stream, WordprocessingDocumentType.Document, true))
            {
                MainDocumentPart głównaCzęśćDokumentu = dokumentWorda.AddMainDocumentPart();
                głównaCzęśćDokumentu.Document = new Document();

                Body ciałoDokumentu = new Body();
                głównaCzęśćDokumentu.Document.AppendChild(ciałoDokumentu);

                string[] linie = dane.Linie;
                Paragraph akapit = twórzAkapit(linie, 25, KolorNormalny);
                ciałoDokumentu.AppendChild(akapit);

                dokumentWorda.Close();
            }
            stream.Flush();
        }

        public static void EksportujDoPlikuDocx(this Dane dane, string ścieżkaPliku, IFormatProvider formatProvider = null)
        {
            if (formatProvider == null) formatProvider = new CultureInfo("pl-PL");
            if (File.Exists(ścieżkaPliku)) File.Delete(ścieżkaPliku);
            using (FileStream strumieńPliku = new FileStream(ścieżkaPliku, FileMode.CreateNew))
            {
                wyślijDokumentDoStrumienia(dane, strumieńPliku, formatProvider);
                strumieńPliku.Close();
            }
        }
    }
}
