﻿


var rect = new Rectangle(2, 4);
var circle = new Circle(35);
void DisplayShape<T>(T shape) where T : IShape
{
    Console.WriteLine(T.Color);
    Console.WriteLine(shape.CalculateArea());
}

DisplayShape(rect);

var biggerShape = GetBiggerShape(rect,circle);

IShape GetBiggerShape<T1,T2>(T1 s1,T2 s2) where T1 : IShape where T2 : IShape
{
    return s1 > s2 ? s1 : s2;
}


public interface IShape
{
    double CalculateArea();
    static abstract string? Color { get; set; }
    static virtual bool operator <(IShape l, IShape r) => l.CalculateArea() < r.CalculateArea();

    static virtual bool operator >(IShape l, IShape r) => l.CalculateArea() > r.CalculateArea();
}

public class Rectangle : IShape
{
    private readonly double _x; 
    private readonly double _y;
    public static string? Color { get; set; } = "red";

    public Rectangle(double x, double y)
    {
       _x= x;
       _y= y;
    }
    public double CalculateArea()=>_x*_y;
}

public class Circle : IShape
{
    private readonly double _r;
    public static string? Color { get; set; } = "blue";

    public Circle(double r)
    {
        _r= r;
    }
    public double CalculateArea() => _r * _r;
}