﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml.Linq;

namespace LinqToXml_WindowsForms
{
    class UstawieniaOkna
    {
        private static string społożenie = "położenie";
        private static string srozmiar = "rozmiar";

        //-------------

        public int X, Y, W, H;
        public string Name;

        public bool Save(string filePath)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("ustawienia",
                        new XElement(społożenie,
                            new XElement("x", X),
                            new XElement("y", Y)
                        ),
                        new XElement(srozmiar,
                            new XElement("w", W),
                            new XElement("h", H)
                        )
                    )
                );
                xml.Root.Add(new XElement("nazwa", Name));
                xml.Save(filePath);
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static UstawieniaOkna Load(string filePath)
        {
            try
            {
                XDocument xml = XDocument.Load(filePath);
                UstawieniaOkna uo = new UstawieniaOkna();
                uo.X = int.Parse(xml.Root.Element(społożenie).Element("x").Value);
                uo.Y = int.Parse(xml.Root.Element(społożenie).Element("y").Value);
                uo.W = int.Parse(xml.Root.Element(srozmiar).Element("w").Value);
                uo.H = int.Parse(xml.Root.Element(srozmiar).Element("h").Value);
                uo.Name = xml.Root.Element("nazwa").Value;
                return uo;
            }
            catch
            {
                UstawieniaOkna uo = new UstawieniaOkna()
                {
                    X = 100,
                    Y = 100,
                    W = 800,
                    H = 640,
                    Name = "UMK"
                };
                return uo;
            }
        }
    }

    static class UstawieniaOknaHelper
    {
        public static bool SaveFormGeometry(this Form form, string filePath)
        {
            UstawieniaOkna uo = new UstawieniaOkna() { X = form.Left, Y = form.Top, W = form.Width, H = form.Height, Name = form.Text };
            return uo.Save(filePath);
        }

        public static void WczytajIZastosuj(this Form form, string filePath)
        {
            UstawieniaOkna uo = UstawieniaOkna.Load(filePath);
            form.Left = uo.X;
            form.Top = uo.Y;
            form.Width = uo.W;
            form.Height = uo.H;
            form.Text = uo.Name;
        }
    }

    public class FormUMK : Form
    {
        private static string formSettingsFilePath = "okno.xml";

        public FormUMK()
        {
            this.StartPosition = FormStartPosition.Manual;
            this.WczytajIZastosuj(formSettingsFilePath);
            this.FormClosed += FormUMK_FormClosed; //błąd: +1/4 do oceny
        }

        private void FormUMK_FormClosed(object sender, FormClosedEventArgs e)
        {
            //new UstawieniaOkna() { X = Left, Y = Top, W = Width, H = Height, Name = this.Name }.Save("okno.xml");
            this.SaveFormGeometry(formSettingsFilePath);
        }
    }
}
