﻿using System;
using System.Collections.Generic;
using static System.Console;

namespace Wariancja
{
    #region Typ Inwariantny
    interface ITypInwariantny<Typ>
    {
        void Nic();
        void PrzyjmijObiekt(Typ obiekt);
        Typ ZwróćObiekt();
        Typ PrzyjmijIZwróćObiekt(Typ obiekt);
    }

    class TypInwariantny<Typ> : ITypInwariantny<Typ>
    {
        public void Nic() { }

        public void PrzyjmijObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
        }

        public Typ ZwróćObiekt()
        {
            return default(Typ);
        }

        public Typ PrzyjmijIZwróćObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
            return obiekt;
        }
    }
    #endregion

    #region Typ Kontrawariantny
    interface ITypKontrawariantny<in Typ> //in = kontrawariantny
    {
        void Nic();
        void PrzyjmijObiekt(Typ obiekt);
        //Typ ZwróćObiekt();
        //Typ PrzyjmijIZwróćObiekt(Typ obiekt);
    }

    class TypKontrawariantny<Typ> : ITypKontrawariantny<Typ>
    {
        public void Nic() { }

        public void PrzyjmijObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
        }

        /*
        public Typ ZwróćObiekt()
        {
            return default(Typ);
        }

        public Typ PrzyjmijIZwróćObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
            return obiekt;
        }
        */
    }
    #endregion

    #region Typ Kontrawariantny
    interface ITypKowariantny<out Typ> //in = kontrawariantny
    {
        void Nic();
        //void PrzyjmijObiekt(Typ obiekt);
        Typ ZwróćObiekt();
        //Typ PrzyjmijIZwróćObiekt(Typ obiekt);
    }

    class TypKowariantny<Typ> : ITypKowariantny<Typ>
    {
        public void Nic() { }

        /*
        public void PrzyjmijObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
        }
        */

        public Typ ZwróćObiekt()
        {
            return default(Typ);
        }

        /*
        public Typ PrzyjmijIZwróćObiekt(Typ obiekt)
        {
            WriteLine(obiekt.ToString());
            return obiekt;
        }
        */
    }
    #endregion

    interface IParametr
    {
        public int a { get; set; }
        public string b { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
            ITypInwariantny<object> o11 = new TypInwariantny<object>();
            TypInwariantny<object> o12 = new TypInwariantny<object>();
            ITypInwariantny<string> o13 = new TypInwariantny<string>();
            TypInwariantny<string> o14 = new TypInwariantny<string>();
            //ITypInwariantny<object> o15 = new TypInwariantny<string>();
            //TypInwariantny<object> o16 = new TypInwariantny<string>();
            //ITypInwariantny<string> o17 = new TypInwariantny<object>();
            //TypInwariantny<string> o18 = new TypInwariantny<object>();

            ITypKontrawariantny<object> o21 = new TypKontrawariantny<object>();
            TypKontrawariantny<object> o22 = new TypKontrawariantny<object>();
            ITypKontrawariantny<string> o23 = new TypKontrawariantny<string>();
            TypKontrawariantny<string> o24 = new TypKontrawariantny<string>();
            //ITypKontrawariantny<object> o25 = new TypKontrawariantny<string>();
            //TypKontrawariantny<object> o26 = new TypKontrawariantny<string>();
            ITypKontrawariantny<string> o27 = new TypKontrawariantny<object>();
            //TypKontrawariantny<string> o28 = new TypKontrawariantny<object>();

            o27.PrzyjmijObiekt("UMK");

            ITypKowariantny<object> o31 = new TypKowariantny<object>();
            TypKowariantny<object> o32 = new TypKowariantny<object>();
            ITypKowariantny<string> o33 = new TypKowariantny<string>();
            TypKowariantny<string> o34 = new TypKowariantny<string>();
            ITypKowariantny<object> o35 = new TypKowariantny<string>();
            //TypKowariantny<object> o36 = new TypKowariantny<string>();
            //ITypKowariantny<string> o37 = new TypKowariantny<object>();
            //TypKowariantny<string> o38 = new TypKowariantny<object>();

            var a = o35.ZwróćObiekt();
            Console.WriteLine(a);
        }
    }
}
