﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Varia
{
    public static class Rozszerzenia
    {
        public static string UsuńApostrof(this string s)
        {
            return s.Replace('\'', '#');
        }

        public static string UsuńApostrof(this string s, char zamiennik = '#')
        {
            return s.Replace('\'', zamiennik);
        }

        public static string UsuńApostrof(this string s, Func<char, char> zmieniacz = null)
        {
            if (zmieniacz == null) zmieniacz = (char c) => { return c; };
            string wynik = "";
            foreach (char c in s)
                wynik += zmieniacz(c);
            return wynik;
        }
    }

    public static class RozszerzeniaLINQ
    {
        public static double Średnia<T>(this IEnumerable<T> dane)              
        {
            IEnumerator<T> iterator = dane.GetEnumerator();

            double średnia = 0;
            int liczbaElementów = 0;
            while(iterator.MoveNext())
            {
                liczbaElementów++;
                //double d = (double)iterator.Current;
                double d = Convert.ToDouble(iterator.Current);
                średnia += d;
            }
            średnia /= liczbaElementów;
            return średnia;
        }

        public static double StdDev<T>(this IEnumerable<T> dane)
        {
            IEnumerator<T> iterator = dane.GetEnumerator();

            double średnia = Średnia(dane);
            double wariancja = 0;
            int liczbaElementów = 0;
            while (iterator.MoveNext())
            {
                liczbaElementów++;
                double d = Convert.ToDouble(iterator.Current);
                double odchylenie = d - średnia;
                wariancja += odchylenie * odchylenie;
            }
            wariancja /= liczbaElementów;
            return Math.Sqrt(wariancja);
        }
    }


    class Program
    {
        static void Main_1(string[] args)
        {
            string wynik = Rozszerzenia.UsuńApostrof("O'Brian");
            Console.WriteLine(wynik);

            wynik = "O'Brian".UsuńApostrof('$');
            Console.WriteLine(wynik);

            Func<char, char> zmieniacz =
                (char c) =>
                {
                    switch(c)
                    {
                        case '\'': return '#';
                        case 'B': return 'M';
                        default: return c;
                    }
                };
            wynik = "O'Brian".UsuńApostrof(zmieniacz);
            Console.WriteLine(wynik);
        }

        static void Main(string[] args)
        {
            List<int> dane = new List<int>() { 1, 2, 3, 8, 9 };
            double wynik1 = dane.Average();
            Console.WriteLine(wynik1);
            double wynik2 = dane.Średnia();
            Console.WriteLine(wynik2);

            double wynik3 = dane.StdDev();
            Console.WriteLine(wynik3);
        }
    }
}
