﻿// See https://aka.ms/new-console-template for more information

using ParaInt = Para<int,int>;

/*
class Para<T> : IComparable<Para<T>>
    where T : IComparable<T>
{
    private T pierwszy = default(T);
    private T drugi = default(T);

    public Para(T pierwszy, T drugi)
    {
        this.pierwszy = pierwszy;
        this.drugi = drugi;
    }

    public override string ToString()
    {
        return $"{pierwszy}\t{drugi}";
    }

    public int CompareTo(Para<T> other)
    {
        int wartość = pierwszy.CompareTo(other.pierwszy);
        if (wartość != 0) return wartość;
        else return drugi.CompareTo(other.drugi);
    }
}
*/

class Para<T,S> : IComparable<Para<T,S>>
    where T : IComparable<T>
    where S : IComparable<S>
{
    private T pierwszy = default(T);
    private S drugi = default(S);

    public Para(T pierwszy, S drugi)
    {
        this.pierwszy = pierwszy;
        this.drugi = drugi;
    }

    public override string ToString()
    {
        return $"{pierwszy}\t{drugi}";
    }

    public int CompareTo(Para<T,S> other)
    {
        int wartość = pierwszy.CompareTo(other.pierwszy);
        if (wartość != 0) return wartość;
        else return drugi.CompareTo(other.drugi);
    }
}

class Program
{
    static void Main(string[] args)
    {
        Random r = new Random();

        Para<int,int>[] pi = new Para<int,int>[10];
        for (int i = 0; i < pi.Length; ++i)
        {
            pi[i] = new Para<int,int>(r.Next(10), r.Next(10));
        }
        Console.WriteLine("Para<int,int>:");
        foreach(Para<int,int> para in pi) 
            Console.WriteLine(para.ToString());
        Array.Sort(pi);
        Console.WriteLine("Para<int,int> - posrtowane:");
        foreach (Para<int, int> para in pi)
            Console.WriteLine(para.ToString());

        Para<string,string>[] ps = new Para<string, string>[10];
        for (int i = 0; i < ps.Length; ++i)
        {
            ps[i] = new Para<string, string>(r.Next(10).ToString(), r.Next(10).ToString());
        }
        Console.WriteLine("Para<string,string>:");
        foreach (Para<string, string> para in ps)
            Console.WriteLine(para.ToString());
        Array.Sort(ps);
        Console.WriteLine("Para<string,string> - posortowane:");
        foreach (Para<string, string> para in ps)
            Console.WriteLine(para.ToString());

        //Para<System.Numerics.Complex>  Complex nie implementuje IComparable<Complex>
        ParaInt pi2 = new ParaInt(0, 0); //użycie aliasu

        Para<string, int>[] psi = new Para<string, int>[10];
        for (int i = 0; i < ps.Length; ++i)
        {
            psi[i] = new Para<string, int>(r.Next(10).ToString(), r.Next(10));
        }
        Console.WriteLine("Para<string,int>:");
        foreach (Para<string, int> para in psi)
            Console.WriteLine(para.ToString());
        Array.Sort(psi);
        Console.WriteLine("Para<string,int> - posortowane:");
        foreach (Para<string, int> para in psi)
            Console.WriteLine(para.ToString());
    }
}
