﻿// See https://aka.ms/new-console-template for more information
Console.WriteLine("Hello, World!");

double obliczenia(double argument)
{
    for(int i = 0; i < 10; ++i)
    {
        argument = Math.Asin(Math.Sin(argument));
        //Console.Write(".");
    }
    return argument;
}

int rozmiar = 10000;
Random r = new Random();
double[] tablica = new double[rozmiar];
for(int i = 0; i < tablica.Length; ++i) tablica[i] = r.NextDouble();

//obliczenia sekwencyjne
int liczbaPowtórzeń = 100;
double[] wyniki = new double[tablica.Length];
int start = Environment.TickCount;
for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; ++powtórzenia)
    for (int i = 0; i < tablica.Length; ++i)
    {
        wyniki[i] = obliczenia(tablica[i]);
        if (i > tablica.Length / 2) break;
    }
int stop = Environment.TickCount;
Console.WriteLine($"Obliczenia sekwencyjne trwały {stop - start}");

//obliczenia równoległe
start = Environment.TickCount;
for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; ++powtórzenia)
    Parallel.For(
        0,
        100,
        (int i, ParallelLoopState pls) =>
        {
            Console.WriteLine(i);
            if (i == 5)
            {
                Console.WriteLine("break");
                pls.Stop();
            }
            if (pls.IsStopped) return;
            if (i % 2 != 0)
                obliczenia(tablica[i]);
        });
stop = Environment.TickCount;
Console.WriteLine($"Obliczenia równoległe trwały {stop - start}");