﻿// See https://aka.ms/new-console-template for more information

class Program
{
    static void Console_WriteLine(string s)
    {
        Console.WriteLine($"*{Task.CurrentId} #{Thread.CurrentThread.ManagedThreadId} {s}");
    }


    static Task<long> ZróbCośAsync(object argument)
    {
        //czynność
        Func<object, long> czynność =
            (object argument) =>
            {
                Console_WriteLine($"Początek czynności - {argument}");
                System.Threading.Thread.Sleep(500);
                Console_WriteLine($"Koniec działania akcji - {argument}");
                return DateTime.Now.Ticks;
                //return Environment.TickCount64;
            };

        Task<long> zadanie = new Task<long>(czynność, "zadanie");
        Console_WriteLine("Zadanie zostanie uruchomione");
        zadanie.Start();
        Console_WriteLine("Zadanie zostało uruchomione");
        return zadanie;
    }

    public async static void _Main()
    {
        Console_WriteLine("AsyncAwait");


        //czynność
        Func<object, long> czynność =
            (object argument) =>
            {
                Console_WriteLine($"Początek czynności - {argument}");
                System.Threading.Thread.Sleep(500);
                Console_WriteLine($"Koniec działania akcji - {argument}");
                return DateTime.Now.Ticks;
                //return Environment.TickCount64;
            };

        long wynik = czynność("synchroniczne");
        Console_WriteLine("Synchronicznie: " + wynik.ToString());
        Console_WriteLine("\n\n");

        Task<long> zadanie = new Task<long>(czynność, "zadanie");
        Console_WriteLine("Zadanie zostanie uruchomione");
        zadanie.Start();
        Console_WriteLine("Zadanie zostało uruchomione");
        wynik = zadanie.Result;
        Console_WriteLine("Zadanie: " + wynik.ToString());
        Console_WriteLine("\n\n");

        Task<long> zadanie2 = ZróbCośAsync("zadanie-metoda");
        Console_WriteLine("Czynność w metodzie async została uruchomiona");
        //wynik = zadanie2.Result;
        wynik = await zadanie2;
        Console_WriteLine("Zadanie - metoda/async: " + wynik.ToString());
    }

    public static void Main(string[] args)
    {
        Console_WriteLine("Main - start");
        _Main();
        Console_WriteLine("Main - stop 1");
        Console.ReadLine();
        Console_WriteLine("Main - stop 2");
    }
}

