﻿using System;

namespace MaszynaTuringa
{
    public static class TuringHelper
    {
        public static void WyświetlBłędy(this ProgramTuringa program)
        {
            if (program.Błędy.Length > 0)
            {
                foreach (ProgramTuringa.Błąd błąd in program.Błędy)
                    Console.WriteLine($"Błąd w linii {błąd.numerLinii}: {błąd.rodzajBłędu}");
                return;
            }
        }

        public static void WyświetlProgram(this ProgramTuringa program)
        {
            Console.WriteLine();
            if (program.Instrukcje.Length == 0) Console.WriteLine("Brak programu");
            else
            {
                Console.WriteLine("Program:");
                foreach (ProgramTuringa.Czwórka linia in program.Instrukcje)
                    Console.WriteLine(linia);
            }
        }

        public static void WyświetlStanMaszyny(this StanMaszynyTuringa stan)
        {
            Console.WriteLine();
            Console.WriteLine("Stan maszyny");
            Console.WriteLine($"Stan głowicy: {stan.StanGłowicy}");
            Console.WriteLine($"Pozycja głowicy: {stan.PozycjaGłowicy}");
            Console.WriteLine($"Taśma: {stan.Taśma}");
        }

        public static void WyświetlTaśmęZGłowicą(this StanMaszynyTuringa stan)
        {
            Console.WriteLine(stan.TaśmaZGłowicą);
        }
    }

    class Program
    {
        static async void Do()
        {
            try
            {
                Turing turing = new Turing("program.txt", "taśma.txt");
                turing.Program.WyświetlProgram();
                turing.Program.WyświetlBłędy();

                turing.Stan.WyświetlStanMaszyny();
                turing.Stan.WykonanieInstrukcji += (object sender, StanMaszynyTuringa.WykonanieInstrukcjiEventArgs e) => { TuringHelper.WyświetlTaśmęZGłowicą(turing.Stan); };
                /*
                turing.Stan.WykonanieInstrukcji += 
                    (object sender, StanMaszynyTuringa.WykonanieInstrukcjiEventArgs e) => 
                    {
                        Console.WriteLine($"[{e.PoprzedniaPozycjaGłowicy}]={e.PoprzedniStanGłowicy} --> [{e.BieżącaPozycjaGłowica}]={e.BieżącyStanGłowicy}");
                    };
                */

                //synchroniczne wykonanie metody
                //string stanKońcowy = turing.Wykonaj();

                //asynchroniczne wykonanie metody, ale z blokadą
                //string stanKońcowy = turing.WykonajAsync().Result;

                string stanKońcowy = await turing.WykonajAsync();
                Console.WriteLine("\nStan końcowy: " + stanKońcowy);
                turing.Stan.WyświetlStanMaszyny();
            }
            catch (TuringException exc)
            {
                ConsoleColor kolor = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.Error.WriteLine("Błąd maszyny turinga: " + exc.Message);
                Console.ForegroundColor = kolor;
            }
            catch (Exception exc)
            {
                ConsoleColor kolor = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Red;
                Console.Error.WriteLine("Nierozpoznany błąd: " + exc.Message);
                Console.ForegroundColor = kolor;
            }
        }


        static void Main(string[] args)
        {
            Console.WriteLine("Przed Do");
            Do();
            Console.WriteLine("Po Do");

            Console.ReadLine();
            Console.WriteLine("OK.");
        }
    }
}
