﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MaszynaTuringa
{
    public static class TuringHelper
    {
        public enum BłądWKodzie 
        { 
            OK,
            CzwórkaNieMaCzterechZnaków,
            PierwszyZnakCzwórkiNieJestMałąLiterą,
            DrugiZnakCzwórkiNieJestDużąLiterą,
            TrzeciZnakCzwórkiNieJestDużąLiterą,
            CzwartyZnakCzwórkiNieJestMałąLiterą
        }

        public static BłądWKodzie CzyInstrukcjaJestPoprawna(string instrukcja)
        {
            if (instrukcja.Length != 4) return BłądWKodzie.CzwórkaNieMaCzterechZnaków;
            if (!char.IsLower(instrukcja[0])) return BłądWKodzie.PierwszyZnakCzwórkiNieJestMałąLiterą;
            if (!char.IsUpper(instrukcja[1])) return BłądWKodzie.DrugiZnakCzwórkiNieJestDużąLiterą;
            if (!char.IsUpper(instrukcja[2])) return BłądWKodzie.TrzeciZnakCzwórkiNieJestDużąLiterą;
            if (!char.IsLower(instrukcja[3])) return BłądWKodzie.CzwartyZnakCzwórkiNieJestMałąLiterą;
            return BłądWKodzie.OK;
        }

        public static (string[] program, (uint numerLinii, BłądWKodzie błąd)[]) WczytajProgram(string ścieżkaPliku)
        {
            string[] instrukcje = System.IO.File.ReadAllLines(ścieżkaPliku);
            List<(uint numerLinii, BłądWKodzie błąd)> błędy = new List<(uint numerLinii, BłądWKodzie błąd)>();
            for(uint i = 0; i < instrukcje.Length; ++i)
            {
                BłądWKodzie wynikSprawdzenia = CzyInstrukcjaJestPoprawna(instrukcje[i]);
                (uint numerLinii, BłądWKodzie błąd) raportBłędu = (i, wynikSprawdzenia);
                if (wynikSprawdzenia != BłądWKodzie.OK) błędy.Add(raportBłędu);
            }
            return (instrukcje, błędy.ToArray());
        }
    }

    class Turing
    {
        public char StanGłowicy { get; private set; }
        public string Taśma { get; private set; }
        public string[] Instrukcje { get; private set; }

        public Turing(char stanGłowicy, string taśma, string[] instrukcje)
        {
            this.StanGłowicy = stanGłowicy;
            this.Taśma = taśma;
            this.Instrukcje = instrukcje;
        }
    }
}
