﻿using System;

namespace Krotki
{
    class Program
    {
        private static (int CzęśćCałkowita, double CzęśćUłamkowa) podzielNaCzęści(double liczba)
        {
            int częśćCałkowita = (int)Math.Truncate(liczba);
            return (częśćCałkowita, liczba - częśćCałkowita);
        }

        //(a = 1, b = -2, c = 1) -> x1 = 1, x2 = 1
        //(a = 1, b = 0, c = -1) -> x1 = -1, x2 = 1
        //(a = 0, b = 2, c = 1) -> wyjątek
        //(a = 1, b = 0, c = 1) -> nie ma rozwiązań (null)

        private static (double x1,double x2)? rozwiążRównanieKwadratowe(double a, double b, double c)
        {
            if (a == 0) throw new ArgumentException("Współczynnik a jest zerem, zatem to funkcja liniowa");
            double delta = b * b - 4 * a * c;
            if (delta < 0) return null;
            double sqrt_delta = Math.Sqrt(delta);

            double x1 = (-b - sqrt_delta) / (2 * a);
            double x2 = (-b + sqrt_delta) / (2 * a);

            return (x1, x2); 
        }

        static void Main(string[] args)
        {
            ValueTuple<int, double, string> a = new ValueTuple<int, double, string>(1, Math.PI, "UMK");
            Console.WriteLine(a);

            (int i, double d, string s) b = (1, Math.PI, "UMK");
            Console.WriteLine(b);

            Console.WriteLine(a == b);
            Console.WriteLine(a.Equals(b));

            Console.WriteLine(b.i);
            Console.WriteLine(b.d);
            Console.WriteLine(b.s);

            /*
            double pi = Math.PI;
            int cc; double cu;
            podzielNaCzęści(pi, out cc, out cu);
            Console.WriteLine(pi);
            Console.WriteLine(cc);
            Console.WriteLine(cu);
            */

            double pi = Math.PI;
            var ccu = podzielNaCzęści(pi);
            Console.WriteLine(pi);
            Console.WriteLine(ccu.CzęśćCałkowita);
            Console.WriteLine(ccu.CzęśćUłamkowa);

            //(a = 1, b = -2, c = 1) -> x1 = 1, x2 = 1
            //(a = 1, b = 0, c = -1) -> x1 = -1, x2 = 1
            //(a = 0, b = 2, c = 1) -> wyjątek
            //(a = 1, b = 0, c = 1) -> nie ma rozwiązań (null)
            Console.WriteLine(rozwiążRównanieKwadratowe(1, -2, 1));
            Console.WriteLine(rozwiążRównanieKwadratowe(1, 0, -1));
            //Console.WriteLine(rozwiążRównanieKwadratowe(0, 2, 1));
            Console.WriteLine(rozwiążRównanieKwadratowe(1, 0, 1) == null);
        }
    }
}
