﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;


namespace WordLibrary
{
    using static FormatowaniaDocx;

    public class ElementyDocx
    {
        private static Paragraph twórzAkapit(string[] linie, int rozmiarCzcionki, Color kolorCzcionki)
        {
            Paragraph akapit = new Paragraph();
            akapit.Append(UstawieniaAkapitu);
            Run ustęp = akapit.AppendChild(new Run());
            RunProperties stylAkapitu = StylUstępNormalny;
            stylAkapitu.FontSize.Val = new StringValue(rozmiarCzcionki.ToString());
            stylAkapitu.Color = kolorCzcionki;
            ustęp.Append(stylAkapitu);
            foreach (string linia in linie)
            {
                ustęp.AppendChild(new Text(linia));
                ustęp.AppendChild(new Break());
            }
            return akapit;
        }

        private static Paragraph twórzAkapitTytułu(string tytuł)
        {
            Paragraph akapit = new Paragraph();
            Run ustęp = akapit.AppendChild(new Run());
            ustęp.Append(StylUstępuTytułu);
            ustęp.AppendChild(new Text(tytuł));
            return akapit;
        }

        private static Stream pobierzRysunekZZasobów(string nazwaZasobu)
        {
            Assembly a = typeof(ElementyDocx).GetTypeInfo().Assembly;
            Stream s = a.GetManifestResourceStream(nazwaZasobu);
            return s;
        }

        private static Stream pobierzRysunekZPliku(string ścieżkaPliku)
        {
            FileStream fs = new FileStream(ścieżkaPliku, FileMode.Open);
            return fs;
        }

        private static Drawing twórzRysunekWDokumencie(WordprocessingDocument dokument, Stream strumień)
        {
            MainDocumentPart mp = dokument.MainDocumentPart;
            ImagePart częśćRysunku = mp.AddImagePart(ImagePartType.Png);
            częśćRysunku.FeedData(strumień);
            return RysunekDocx.CreateDrawingElement(dokument, mp.GetIdOfPart(częśćRysunku), 2, 1);
        }

        private static Paragraph twórzAkapitZRysunkiem(Drawing rysunek)
        {
            return new Paragraph(new Run(rysunek));
        }

        private static Table twórzTabelę(string[,] komórki, string[] komórkiNagłówka = null)
        {
            if (komórkiNagłówka != null && komórkiNagłówka.Length != komórki.GetLength(0))
                throw new Exception("Nieprawidłowa liczba elementów nagłówka");

            Table tabela = new Table();

            uint grubośćZewnętrznejLinii = 10;
            uint grubośćWewnętrznejLinii = 2;

            TableProperties własnościTabeli = new TableProperties(
                new TableBorders(
                    new TopBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćZewnętrznejLinii },
                    new BottomBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćZewnętrznejLinii },
                    new LeftBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćZewnętrznejLinii },
                    new RightBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćZewnętrznejLinii },
                    new InsideHorizontalBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćWewnętrznejLinii },
                    new InsideVerticalBorder() { Val = new EnumValue<BorderValues>(BorderValues.BasicThinLines), Size = grubośćWewnętrznejLinii }
                ));
            tabela.AppendChild(własnościTabeli);

            if(komórkiNagłówka!=null)
            {
                TableRow wierszNagłowka = new TableRow();
                for(int i = 0; i < komórkiNagłówka.Length; ++i)
                {
                    TableCell komórkaNagłówka = new TableCell();
                    komórkaNagłówka.Append(new TableCellProperties(new TableCellWidth() { Type = TableWidthUnitValues.Dxa, Width = "2400" }));
                    Run ustępKomórkiTabeli = new Run(new Text(komórkiNagłówka[i]));
                    ustępKomórkiTabeli.RunProperties = new RunProperties()
                    {
                        Bold = new Bold() { Val = OnOffValue.FromBoolean(true) },
                        Color = KolorWyróżniony
                    };
                    komórkaNagłówka.Append(new Paragraph(ustępKomórkiTabeli));
                    wierszNagłowka.Append(komórkaNagłówka);
                }
                tabela.Append(wierszNagłowka);

                for (int wiersz = 0; wiersz < komórki.GetLength(1); ++wiersz)
                {
                    TableRow wierszTabeli = new TableRow();
                    for (int kolumna = 0; kolumna < komórki.GetLength(0); ++kolumna)
                    {
                        TableCell komórka = new TableCell();
                        komórka.Append(new TableCellProperties(new TableCellWidth() { Type = TableWidthUnitValues.Dxa, Width = "2400" }));
                        komórka.Append(new Paragraph(new Run(new Text(komórki[kolumna, wiersz]))));
                        wierszTabeli.Append(komórka);
                    }
                    tabela.Append(wierszTabeli);
                }                
            }

            return tabela;
        }


        public class DaneDoRaportu
        {
            public string[] Linie =
            {
                "Aenean nec lorem. In porttitor. Donec laoreet nonummy augue.",
                "Suspendisse dui purus, scelerisque at, vulputate vitae, pretium mattis, nunc. Mauris eget neque at sem venenatis eleifend.Ut nonummy.",
                "Fusce aliquet pede non pede. Suspendisse dapibus lorem pellentesque magna.Integer nulla.",
                "Donec blandit feugiat ligula. Donec hendrerit, felis et imperdiet euismod, purus ipsum pretium metus, in lacinia nulla nisl eget sapien.Donec ut est in lectus consequat consequat.",
                "Etiam eget dui.Aliquam erat volutpat.Sed at lorem in nunc porta tristique.",
                "Proin nec augue.Quisque aliquam tempor magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas."
            };
        }

        private static void wyślijDokumentDoStrumienia(
            DaneDoRaportu daneDoRaportu, Stream strumień, IFormatProvider fp)
        {
            using (WordprocessingDocument dokumentWorda =
                WordprocessingDocument.Create(strumień, WordprocessingDocumentType.Document, true))
            {
                MainDocumentPart głównaCzęśćDokumentu = dokumentWorda.AddMainDocumentPart();
                głównaCzęśćDokumentu.Document = new Document();

                Body ciałoDokumentu = new Body();
                głównaCzęśćDokumentu.Document.AppendChild(ciałoDokumentu);

                //rysunek
                //Stream strumieńRysunku = pobierzRysunekZZasobów("WordLibrary.rysunki.logo-umk.png");
                Stream strumieńRysunku = pobierzRysunekZPliku("rysunki\\logo-umk.png");
                Drawing rysunek = twórzRysunekWDokumencie(dokumentWorda, strumieńRysunku);
                Paragraph akapitObrazu = twórzAkapitZRysunkiem(rysunek);
                ciałoDokumentu.AddChild(akapitObrazu);

                //nagłówek
                string[] linieNagłówka = new string[]
                {
                    "e-mail: wfaiis@umk.pl",
                    "www.fizyka.umk.pl",
                    "tel. 56 611 3110"
                };
                Paragraph akapitNagłówka = twórzAkapit(linieNagłówka, 16, KolorWyróżniony);
                ciałoDokumentu.AppendChild(akapitNagłówka);

                //tytuł
                ciałoDokumentu.AppendChild(twórzAkapitTytułu("Kurs .NET jest dziś nudny"));

                string[] linie = daneDoRaportu.Linie;
                Paragraph akapit = twórzAkapit(linie, 25, KolorNormalny);
                ciałoDokumentu.AppendChild(akapit);

                //tabela
                string[,] komórki = new string[4, 3];
                komórki[0, 0] = "Jacek";
                komórki[1, 0] = "Matulewski";
                komórki[2, 0] = "jacek@phys.uni.torun.pl";
                komórki[3, 0] = "Toruń";
                komórki[0, 1] = "Jacek1";
                komórki[1, 1] = "Matulewski1";
                komórki[2, 1] = "jacek@phys.uni.torun.pl1";
                komórki[3, 1] = "Toruń1";
                komórki[0, 2] = "Jacek2";
                komórki[1, 2] = "Matulewski2";
                komórki[2, 2] = "jacek@phys.uni.torun.pl2";
                komórki[3, 2] = "Toruń2";
                string[] nagłówek = new string[] { "Imię", "Nazwisko", "e-mail", "Miasto" };
                Table tabela = twórzTabelę(komórki, nagłówek);
                ciałoDokumentu.Append(tabela);

                dokumentWorda.Close();
            }
            strumień.Flush();
        }

        public static void EksportujDoPlikuDocx(
            DaneDoRaportu daneDoRaportu,
            string ścieżkaDoPliku, IFormatProvider fp)
        {
            if (File.Exists(ścieżkaDoPliku)) File.Delete(ścieżkaDoPliku);
            using(FileStream strumieńPliku = new FileStream(ścieżkaDoPliku, FileMode.CreateNew))
            {
                wyślijDokumentDoStrumienia(daneDoRaportu, strumieńPliku, fp);
                strumieńPliku.Close();
            }
        }
    }
}
