﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;


namespace WordLibrary
{
    using static FormatowaniaDocx;

    public class ElementyDocx
    {
        private static Paragraph twórzAkapit(string[] linie, int rozmiarCzcionki, Color kolorCzcionki)
        {
            Paragraph akapit = new Paragraph();
            akapit.Append(UstawieniaAkapitu);
            Run ustęp = akapit.AppendChild(new Run());
            RunProperties stylAkapitu = StylUstępNormalny;
            stylAkapitu.FontSize.Val = new StringValue(rozmiarCzcionki.ToString());
            stylAkapitu.Color = kolorCzcionki;
            ustęp.Append(stylAkapitu);
            foreach (string linia in linie)
            {
                ustęp.AppendChild(new Text(linia));
                ustęp.AppendChild(new Break());
            }
            return akapit;
        }

        private static Paragraph twórzAkapitTytułu(string tytuł)
        {
            Paragraph akapit = new Paragraph();
            Run ustęp = akapit.AppendChild(new Run());
            ustęp.Append(StylUstępuTytułu);
            ustęp.AppendChild(new Text(tytuł));
            return akapit;
        }

        public class DaneDoRaportu
        {
            public string[] Linie =
            {
                "Aenean nec lorem. In porttitor. Donec laoreet nonummy augue.",
                "Suspendisse dui purus, scelerisque at, vulputate vitae, pretium mattis, nunc. Mauris eget neque at sem venenatis eleifend.Ut nonummy.",
                "Fusce aliquet pede non pede. Suspendisse dapibus lorem pellentesque magna.Integer nulla.",
                "Donec blandit feugiat ligula. Donec hendrerit, felis et imperdiet euismod, purus ipsum pretium metus, in lacinia nulla nisl eget sapien.Donec ut est in lectus consequat consequat.",
                "Etiam eget dui.Aliquam erat volutpat.Sed at lorem in nunc porta tristique.",
                "Proin nec augue.Quisque aliquam tempor magna. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas."
            };
        }

        private static void wyślijDokumentDoStrumienia(
            DaneDoRaportu daneDoRaportu, Stream strumień, IFormatProvider fp)
        {
            using (WordprocessingDocument dokumentWorda =
                WordprocessingDocument.Create(strumień, WordprocessingDocumentType.Document, true))
            {
                MainDocumentPart głównaCzęśćDokumentu = dokumentWorda.AddMainDocumentPart();
                głównaCzęśćDokumentu.Document = new Document();

                Body ciałoDokumentu = new Body();
                głównaCzęśćDokumentu.Document.AppendChild(ciałoDokumentu);

                //nagłówek
                string[] linieNagłówka = new string[]
                {
                    "e-mail: wfaiis@umk.pl",
                    "www.fizyka.umk.pl",
                    "tel. 56 611 3110"
                };
                Paragraph akapitNagłówka = twórzAkapit(linieNagłówka, 16, KolorWyróżniony);
                ciałoDokumentu.AppendChild(akapitNagłówka);

                //tytuł
                ciałoDokumentu.AppendChild(twórzAkapitTytułu("Kurs .NET jest dziś nudny"));

                string[] linie = daneDoRaportu.Linie;
                Paragraph akapit = twórzAkapit(linie, 25, KolorNormalny);
                ciałoDokumentu.AppendChild(akapit);

                dokumentWorda.Close();
            }
            strumień.Flush();
        }

        public static void EksportujDoPlikuDocx(
            DaneDoRaportu daneDoRaportu,
            string ścieżkaDoPliku, IFormatProvider fp)
        {
            if (File.Exists(ścieżkaDoPliku)) File.Delete(ścieżkaDoPliku);
            using(FileStream strumieńPliku = new FileStream(ścieżkaDoPliku, FileMode.CreateNew))
            {
                wyślijDokumentDoStrumienia(daneDoRaportu, strumieńPliku, fp);
                strumieńPliku.Close();
            }
        }
    }
}
