﻿using System;
using System.Threading.Tasks;

namespace Równoległe
{
    class Program
    {
        private static double obliczenia(double argument)
        {
            for (int i = 0; i < 300; ++i)
                argument = Math.Asin(Math.Sin(argument));
            return argument;
        }

        static void Main_Pętle(string[] args)
        {
            //przygotowania
            Random r = new Random();
            int rozmiar = 10000;
            double[] dane = new double[rozmiar];
            for (int i = 0; i < dane.Length; ++i) dane[i] = r.NextDouble();

            Console.WriteLine("Liczba procesorów: " + System.Environment.ProcessorCount);

            //obliczenia sekwencyjne
            int liczbaPowtórzeń = 100;
            double[] wyniki = new double[rozmiar];
            int start = System.Environment.TickCount;
            for (int powtórzenie = 0; powtórzenie < liczbaPowtórzeń; powtórzenie++)
            {
                for (int i = 0; i < dane.Length; ++i)
                    wyniki[i] = obliczenia(dane[i]);
            }
            int stop = System.Environment.TickCount;
            int czasSekw = stop - start;
            Console.WriteLine("Czas obliczeń sekw.: " + czasSekw.ToString() + " ms");

            //obliczenia równoległe
            Action<int> body = (int i) => { wyniki[i] = obliczenia(dane[i]); };
            start = System.Environment.TickCount;
            for (int powtórzenie = 0; powtórzenie < liczbaPowtórzeń; powtórzenie++)
            {
                Parallel.For(0, dane.Length, body);
            }
            stop = System.Environment.TickCount;
            int czasRówn = stop - start;
            Console.WriteLine("Czas obliczeń równ.: " + czasRówn.ToString() + " ms");

            Console.WriteLine("\"Przyspieszenie\": " + (double)czasSekw / czasRówn);
        }

        static void Main_Pętle2(string[] args)
        {
            Random r = new Random(); //nie jest bezpieczny dla wielu wątków
            long suma = 0;
            long licznik = 0;

            Action<int,ParallelLoopState> akcja =
                (int i, ParallelLoopState stanPętli) =>
                {
                    string _s = "";
                    int liczba = r.Next(7);
                    if(liczba == 0)
                    {
                        Console.WriteLine("Stop");
                        _s += "Stop; ";
                        stanPętli.Stop(); //break
                    }
                    //if (stanPętli.IsStopped) return;
                    if (liczba % 2 == 0)
                    {
                        _s += liczba.ToString() + "; ";
                        obliczenia(liczba);
                        suma += liczba;
                        licznik++;
                    }
                    else _s += "[" + liczba.ToString() + "]; ";

                    Console.WriteLine($"{liczba} {licznik} {suma} {_s}");
                };

            int start = System.Environment.TickCount;
            Parallel.For(0, 1000, akcja);
            int stop = System.Environment.TickCount;
            Console.WriteLine("Duration: " + (stop - start).ToString() + " ms");

            Console.ReadLine();
        }
        //static void Main(string[] args)
        //{
        //    Func<object, long> akcja =
        //        (object argument) =>
        //        {
        //            Console.WriteLine("Początek działania akcji - " + argument + ", " + System.Threading.Thread.CurrentThread.ManagedThreadId);
        //            System.Threading.Thread.Sleep(500);
        //            Console.WriteLine("Koniec działania akcji - " + argument + ", " + System.Threading.Thread.CurrentThread.ManagedThreadId);
        //            return DateTime.Now.Ticks;
        //        };

        //    /*
        //    long wynik = akcja("synchronicznie");
        //    Console.WriteLine("Synchronicznie: " + wynik.ToString());
        //    Console.ReadLine();
        //    //6 wątków
        //    */
            
        //    Task<long> zadanie = new Task<long>(akcja, "zadanie");
        //    zadanie.Start();
        //    Console.WriteLine("Akcja została uruchomiona, " + System.Threading.Thread.CurrentThread.ManagedThreadId);
        //    //zadanie.Wait(); //synchronizacja
        //    long wynik = zadanie.Result; //też synchronizacja
        //    Console.WriteLine("Zadanie: " + wynik.ToString());
        //    //Console.WriteLine("Nie interesuje mnie wynik");
        //    Console.ReadLine();
        //}

        static Task<long> ZróbCośAsync(object argument)
        {
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + argument + ", " + System.Threading.Thread.CurrentThread.ManagedThreadId);
                    System.Threading.Thread.Sleep(500);
                    Console.WriteLine("Koniec działania akcji - " + argument + ", " + System.Threading.Thread.CurrentThread.ManagedThreadId);
                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("ZróbCośAsync kończone, " + System.Threading.Thread.CurrentThread.ManagedThreadId);
            return zadanie;
        }

        static async void _Main()
        {
            Task<long> zadanie = ZróbCośAsync("zadanie-metoda");
            Console.WriteLine("Metoda została uruchomiona, " + System.Threading.Thread.CurrentThread.ManagedThreadId);
            //long wynik = zadanie.Result; //synchronizacja
            long wynik = await zadanie;
            Console.WriteLine("Zadanie: " + wynik.ToString() + ", " + System.Threading.Thread.CurrentThread.ManagedThreadId);
            //Console.WriteLine("Nie interesuje mnie wynik");
        }

        static void Main(string[] args)
        {
            Console.WriteLine("Main start: " + System.Threading.Thread.CurrentThread.ManagedThreadId);
            _Main();
            Console.WriteLine("Main stop: " + System.Threading.Thread.CurrentThread.ManagedThreadId);
            Console.ReadLine();
        }
    }
}