﻿using System.ComponentModel.DataAnnotations;

namespace EF
{
    public class Osoba
    {
        [Key] public int Id { get; set; } //primary key
        public string Imię { get; set; }
        public string Nazwisko { get; set; }
        public int NumerTelefonu { get; set; }

        public Adres Adres { get; set; }

        public override string ToString()
        {
            return $"{Id}. {Imię} {Nazwisko}, tel. {NumerTelefonu}, zam. {Adres}";
        }

        public override bool Equals(object obj)
        {
            if (obj is not Osoba) return false;
            Osoba innaOsoba = obj as Osoba;
            return
                Id == innaOsoba.Id &&
                Imię.Equals(innaOsoba.Imię) &&
                Nazwisko.Equals(innaOsoba.Nazwisko);
        }

        public override int GetHashCode()
        {
            return Id.GetHashCode() ^ Imię.GetHashCode() ^ Nazwisko.GetHashCode();
        }
    }

    public class Adres
    {
        [Key] public int Id { get; set; }
        public string Miasto { get; set; }
        public string Ulica { get; set; }
        public int NumerDomu { get; set; }
        public int? NumerMieszkania { get; set; }

        public override bool Equals(object obj)
        {
            if (obj is not Adres) return false;
            Adres innyAdres = obj as Adres;
            return
                Miasto.Equals(innyAdres.Miasto) &&
                Ulica.Equals(innyAdres.Ulica) &&
                NumerDomu == innyAdres.NumerDomu &&
                NumerMieszkania == innyAdres.NumerMieszkania;
        }

        public override string ToString()
        {
            return $"{Miasto}, ul. {Ulica} {NumerDomu}/{NumerMieszkania}".TrimEnd('/');
        }

        public override int GetHashCode()
        {
            return Miasto.GetHashCode() ^ Ulica.GetHashCode() ^ NumerDomu.GetHashCode() ^ NumerMieszkania.GetHashCode();
        }
    }
}
