﻿using System;

namespace Interfejsy.Model
{
    public interface IFigura
    {
        double Pole { get; }
        double ObliczObwód();
    }

    public class Prostokąt : IFigura
    {
        private double a, b;

        public Prostokąt(double a, double b)
        {
            this.a = a;
            this.b = b;
        }

        public double Pole
        {
            get
            {
                return a * b;
            }
        }

        public double ObliczObwód()
        {
            return 2 * a + 2 * b;
        }
    }

    public class Okrąg : IFigura
    {
        private double r;

        public Okrąg(double r)
        {
            this.r = r;
        }

        public double Pole
        {
            get
            {
                return Math.PI * r * r;
            }
        }

        public double ObliczObwód()
        {
            return 2 * Math.PI * r;
        }
    }
}
