﻿using System;
using System.Linq;
using System.Collections.Generic;

namespace Turing
{
    public class Program
    {
        #region Stan maszyny
        public struct StanMaszyny
        {
            public char[] Taśma;
            public char StanGłowicy;
            public int PołożenieGłowicy;

            public StanMaszyny(char[] taśma, char stanGłowicy, int położenieGłowicy)
            {
                this.Taśma = taśma;
                this.StanGłowicy = stanGłowicy;
                this.PołożenieGłowicy = położenieGłowicy;
            }

            public string TwórzŁańcuchOpisującyStanMaszyny()
            {
                string s = new string(Taśma);
                s = s.Insert(PołożenieGłowicy, StanGłowicy.ToString());
                return s;
            }

            public override string ToString()
            {
                return TwórzŁańcuchOpisującyStanMaszyny();
            }

            public static StanMaszyny Parsuj(string łańcuchOpisującyStanMaszyny)
            {
                char? początkowyStanGłowicy = null;
                int początkowePołożenieGłowicy = -1;
                for (int i = 0; i < łańcuchOpisującyStanMaszyny.Length; i++)
                {
                    char c = łańcuchOpisującyStanMaszyny[i];
                    if (c == 'L' || c == 'R')
                        throw new Exception("Taśma nie może zawierać poleceń L i R");
                    if (char.IsLower(c))
                    {
                        if (początkowyStanGłowicy.HasValue)
                            throw new Exception("Opis stanu maszyny nie może zawierać dwóch głowic");
                        początkowyStanGłowicy = c;
                        początkowePołożenieGłowicy = i;
                        łańcuchOpisującyStanMaszyny = łańcuchOpisującyStanMaszyny.Remove(początkowePołożenieGłowicy, 1);
                    }
                    else
                    {
                        if (c < 'A' || c > 'Z') throw new Exception("Niedozwolone znaki na taśmie");
                    }
                }
                if (!początkowyStanGłowicy.HasValue || początkowePołożenieGłowicy == -1)
                    throw new Exception("Opis stanu maszyny nie zawiera głowicy");
                return new StanMaszyny(łańcuchOpisującyStanMaszyny.ToCharArray(), początkowyStanGłowicy.Value, początkowePołożenieGłowicy);
            }

            public char StanKomórki
            {
                get
                {
                    //TODO: sprawdzić czy w zakresie taśmy
                    return Taśma[PołożenieGłowicy];
                }
                set
                {
                    Taśma[PołożenieGłowicy] = value;
                }
            }
        }

        /*
        //public static (char[] taśma, char stanGłowicy, int położenieGłowicy) AnalizujOpisStanuMaszyny(string łańcuchOpisującyStanMaszyny)
        public static StanMaszyny AnalizujOpisStanuMaszyny(string łańcuchOpisującyStanMaszyny)
        {
            char? początkowyStanGłowicy = null;
            int początkowePołożenieGłowicy = -1;
            for (int i = 0; i < łańcuchOpisującyStanMaszyny.Length; i++)
            {
                char c = łańcuchOpisującyStanMaszyny[i];
                if (c == 'L' || c == 'R')
                    throw new Exception("Taśma nie może zawierać poleceń L i R");
                if (char.IsLower(c))
                {
                    if (początkowyStanGłowicy.HasValue)
                        throw new Exception("Opis stanu maszyny nie może zawierać dwóch głowic");
                    początkowyStanGłowicy = c;
                    początkowePołożenieGłowicy = i;
                    łańcuchOpisującyStanMaszyny = łańcuchOpisującyStanMaszyny.Remove(początkowePołożenieGłowicy, 1);
                }
                else
                {
                    if (c < 'A' || c > 'Z') throw new Exception("Niedozwolone znaki na taśmie");
                }
            }
            if (!początkowyStanGłowicy.HasValue || początkowePołożenieGłowicy == -1)
                throw new Exception("Opis stanu maszyny nie zawiera głowicy");
            return new StanMaszyny(łańcuchOpisującyStanMaszyny.ToCharArray(), początkowyStanGłowicy.Value, początkowePołożenieGłowicy);
        }
        */

        /*
        //public static string TwórzŁańcuchOpisującyStanMaszyny(char[] taśma, char stanGłowicy, int położenieGłowicy)
        public static string TwórzŁańcuchOpisującyStanMaszyny(StanMaszyny stanMaszyny)
        {
            string s = new string(stanMaszyny.Taśma);
            s = s.Insert(stanMaszyny.PołożenieGłowicy, stanMaszyny.StanGłowicy.ToString());
            return s;            
        }
        */
        #endregion

        #region Program
        public class LiniaProgramu
        {
            char początkowyStanGłowicy, końcowyStanGłowicy;
            char początkowyStanKomórki, końcowyStanKomórki;

            public char KońcowyStanGłowicy
            {
                get
                {
                    return końcowyStanGłowicy;
                }
            }

            public char KońcowyStanKomórki
            {
                get
                {
                    return końcowyStanKomórki;
                }
            }

            public override string ToString()
            {
                return $"{początkowyStanGłowicy}{początkowyStanKomórki}{końcowyStanKomórki}{końcowyStanGłowicy}";
            }

            public bool CzyZgodna(char stanGłowicy, char stanKomórki)
            {
                return stanGłowicy == this.początkowyStanGłowicy && stanKomórki == this.początkowyStanKomórki;
            }

            public bool CzyZgodna(LiniaProgramu innaLiniaProgramu)
            {
                return innaLiniaProgramu.początkowyStanGłowicy == this.początkowyStanGłowicy && innaLiniaProgramu.początkowyStanKomórki == this.początkowyStanKomórki;
            }

            /*
            //sprawdza tylko jednoznaczność linii programu (dwa pierwsze znaki)
            public override bool Equals(object obj)
            {
                if (obj == null) return false;
                if (obj is not LiniaProgramu) return false;
                LiniaProgramu lpObj = obj as LiniaProgramu;
                return lpObj.początkowyStanGłowicy == początkowyStanGłowicy && lpObj.początkowyStanKomórki == początkowyStanKomórki;
            }
            */

            public override int GetHashCode()
            {
                return początkowyStanGłowicy ^ początkowyStanKomórki ^ końcowyStanKomórki ^ końcowyStanGłowicy; 
            }

            //TODO: określić obiekt-parę głowica+komórka
            public LiniaProgramu(char początkowyStanGłowicy, char początkowyStanKomórki, char końcowyStanKomórki, char końcowyStanGłowicy)
            {
                if (!char.IsLower(początkowyStanGłowicy)) throw new Exception("Stan głowicy powinien być zapisany małą literą");
                if (char.IsLower(początkowyStanKomórki)) throw new Exception("Stan komórki powinien być zapisany małą literą");
                if(początkowyStanKomórki == 'R' || początkowyStanKomórki == 'L') throw new Exception("Początkowy stan komórki nie może być R lub L");
                //TODO: uzupełnić weryfikację np. o znaki spoza A-Z
                if (char.IsLower(końcowyStanKomórki)) throw new Exception("Stan komórki powinien być zapisany małą literą");
                if (!char.IsLower(końcowyStanGłowicy)) throw new Exception("Stan głowicy powinien być zapisany małą literą");
                this.początkowyStanGłowicy = początkowyStanGłowicy;
                this.początkowyStanKomórki = początkowyStanKomórki;
                this.końcowyStanKomórki = końcowyStanKomórki;
                this.końcowyStanGłowicy = końcowyStanGłowicy;
            }

            /*
            //niezadawalające rozwiązanie
            public LiniaProgramu(string linia)
                //:this(linia[0], linia[1], linia[2], linia[3])
            {
                if (linia.Length != 4) throw new Exception("Linia programu musi mieć 4 znaki");
                new LiniaProgramu(linia[0], linia[1], linia[2], linia[3]);
            }
            */

            public static LiniaProgramu ParsujLinię(string linia)
            {
                if (linia.Length != 4) throw new Exception("Linia programu musi mieć 4 znaki");
                return new LiniaProgramu(linia[0], linia[1], linia[2], linia[3]);
            }
        }

        public class ProgramTuring
        {
            public LiniaProgramu[] LinieProgramu;

            public ProgramTuring(string[] linie)
            {
                List<LiniaProgramu> linieProgramu = new List<LiniaProgramu>();
                foreach(string linia in linie)
                {
                    LiniaProgramu liniaProgramu = LiniaProgramu.ParsujLinię(linia);
                    //if (linieProgramu.Any(l => l.Equals(liniaProgramu)))
                    if(linieProgramu.Any(l => l.CzyZgodna(liniaProgramu)))
                    {
                        throw new Exception("Powtórzona linia");
                    }
                    else
                    {
                        linieProgramu.Add(liniaProgramu);
                    }
                }
                LinieProgramu = linieProgramu.ToArray();
            }

            public override string ToString()
            {
                string s = "Program:\n";
                foreach(LiniaProgramu liniaProgramu in LinieProgramu)
                    s += liniaProgramu.ToString() + "\n";
                return s;
            }

            //ta metoda może zwrócić wyjątek
            public LiniaProgramu ZnajdźLinię(char bieżącyStanGłowicy, char bieżącyStanKomórki)
            {
                LiniaProgramu liniaProgramu = LinieProgramu.First(l => l.CzyZgodna(bieżącyStanGłowicy, bieżącyStanKomórki));
                return liniaProgramu;
            }
        }
        #endregion

        #region Wczytywanie z pliku
        public static string WczytajOpisującyStanMaszynyZPliku(string ścieżkaPliku)
        {
            string s = System.IO.File.ReadAllText(ścieżkaPliku);
            return s;
        }

        public static string[] WczytajProgramZPliku(string ścieżkaPliku)
        {
            string[] linie = System.IO.File.ReadAllLines(ścieżkaPliku);
            return linie;
        }
        #endregion

        #region Procesor
        public static StanMaszyny[] Wykonaj(StanMaszyny początkowyStanMaszyny, ProgramTuring program)
        {
            List<StanMaszyny> historiaStanów = new List<StanMaszyny>();
            historiaStanów.Add(początkowyStanMaszyny);

            StanMaszyny stanMaszyny = początkowyStanMaszyny;            
            do
            {
                try
                {
                    LiniaProgramu liniaProgramu = program.ZnajdźLinię(stanMaszyny.StanGłowicy, stanMaszyny.StanKomórki);
                    stanMaszyny.StanGłowicy = liniaProgramu.KońcowyStanGłowicy;
                    if (liniaProgramu.KońcowyStanKomórki == 'R') stanMaszyny.PołożenieGłowicy++;
                    else if (liniaProgramu.KońcowyStanKomórki == 'L') stanMaszyny.PołożenieGłowicy--;
                    else stanMaszyny.StanKomórki = liniaProgramu.KońcowyStanKomórki;
                }
                catch
                {
                    goto koniec;
                }

                historiaStanów.Add(stanMaszyny);
            }
            while(true);

            koniec:
            return historiaStanów.ToArray();
        }
        #endregion

        static void Main(string[] args)
        {
            /*
            //TODO: przenieść do testów
            LiniaProgramu a = LiniaProgramu.ParsujLinię("qABs");
            LiniaProgramu b = LiniaProgramu.ParsujLinię("qABq");
            bool wynik = a.Equals(b);
            Console.WriteLine(wynik);
            return;
            */

            string[] linieProgramu = WczytajProgramZPliku("program.txt");
            ProgramTuring program = new ProgramTuring(linieProgramu);
            Console.WriteLine(program.ToString());

            StanMaszyny stanMaszyny = StanMaszyny.Parsuj(WczytajOpisującyStanMaszynyZPliku("turing.txt"));
            Console.WriteLine(stanMaszyny.TwórzŁańcuchOpisującyStanMaszyny());

            StanMaszyny[] historiaStanów = Wykonaj(stanMaszyny, program);
            foreach(StanMaszyny sm in historiaStanów)
            {
                Console.WriteLine(sm.TwórzŁańcuchOpisującyStanMaszyny());
            }    
        }
    }
}
