﻿using System.Xml.Linq;

namespace Kolory4.Model
{
    internal static class Ustawienia
    {
        private static string ścieżkaPliku = 
            System.IO.Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "kolory.xml");

        public static void Zapisz(this Kolor kolor)
        {
            XDocument xml = new XDocument(
                new XComment("Zapisano " + DateTime.Now.ToString()),
                new XElement("ustawienia",
                    new XElement("r", kolor.R),
                    new XElement("g", kolor.G),
                    new XElement("b", kolor.B)
                    )
                );
            xml.Save(ścieżkaPliku);
        }

        public static Kolor Czytaj()
        {
            if (!File.Exists(ścieżkaPliku)) return Kolor.Czerń;
            XDocument xml = XDocument.Load(ścieżkaPliku);
            byte r = byte.Parse(xml.Root.Element("r").Value);
            byte g = byte.Parse(xml.Root.Element("g").Value);
            byte b = byte.Parse(xml.Root.Element("b").Value);
            return new Kolor(r, g, b);
        }
    }
}
