﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kolory4
{
    internal class ByteToDoubleConverter : IValueConverter
    {
        public double Zakres { get; set; } = 255.0;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            byte bvalue = (byte)value;
            double dvalue = bvalue / Zakres;
            return dvalue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double dvalue = (double)value;
            byte bvalue = (byte)(dvalue * Zakres);
            return bvalue;
        }
    }

    public class ByteToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            byte bvalue = (byte)value;
            return bvalue.ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class RgbToBrushConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            if (values.Any(e => e == null)) return Brush.Black;
            byte r = (byte)values[0];
            byte g = (byte)values[1];
            byte b = (byte)values[2];
            SolidColorBrush pędzel = new SolidColorBrush(Color.FromRgb(r, g, b));
            return pędzel;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
