using Microsoft.VisualStudio.TestTools.UnitTesting;
using Turing;

namespace TuringTestyJednostkowe
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestAnalizyacychaOpisujcegoStanMaszyny()
        {
            string acuchOpisujcyStanMaszyny = "AqAAABAA";
            var stanMaszyny = Program.analizujOpisStanuMaszyny(acuchOpisujcyStanMaszyny);

            //oczekiwane wartoci
            char stanGowicy = 'q';
            int pooenieGowicy = 1;
            string tama = "AAAABAA";

            Assert.AreEqual(stanGowicy, stanMaszyny.stanGowicy);
            Assert.AreEqual(pooenieGowicy, stanMaszyny.pooenieGowicy);
            Assert.AreEqual(tama, new string(stanMaszyny.tama));
        }

        [TestMethod]
        public void TestTworzeniaacychaOpisujcegoStanMaszyny()
        {
            char stanGowicy = 'q';
            int pooenieGowicy = 1;
            char[] tama = "AAAABAA".ToCharArray();

            string s = Program.pobierzacuchOznaczajcyStanMaszyny((tama, stanGowicy, pooenieGowicy));

            string oczekiwanyacuchOpisujcyStanMaszyny = "AqAAABAA";

            Assert.AreEqual(oczekiwanyacuchOpisujcyStanMaszyny, s);
        }

        [TestMethod]
        public void TestAnalizyIPobieraniaacychaOpisujcegoStanMaszyny()
        {
            string acuchOpisujcyStanMaszyny = "AqAAABAA";
            var stanMaszyny = Program.analizujOpisStanuMaszyny(acuchOpisujcyStanMaszyny);
            string s = Program.pobierzacuchOznaczajcyStanMaszyny(stanMaszyny);

            Assert.AreEqual(acuchOpisujcyStanMaszyny, s);
        }
    }
}
