﻿using CodeRepo.Libs;
using CodeRepo.Models;
using CodeRepo.Views;
using System.Collections.ObjectModel;
using System.Windows.Input;

namespace CodeRepo.ViewModels
{
    public class MainViewModel : NotifyObject
    {
        public MainViewModel()
        {
            UpdateFragments();
        }

        private ObservableCollection<Fragment> _fragments = new ObservableCollection<Fragment>();
        public ObservableCollection<Fragment> Fragments
        {
            get => _fragments;
            set
            {
                if (_fragments == value) return;
                _fragments = value;
                OnPropertyChanged(() => Fragments);
            }
        }

        private Fragment _selectedFragment;
        public Fragment SelectedFragment
        {
            get => _selectedFragment;
            set
            {
                if (_selectedFragment == value) return;
                _selectedFragment = value;
                OnPropertyChanged(() => SelectedFragment);
            }
        }

        #region Add

        RelayCommand _addCommand;
        public ICommand AddCommand => _addCommand ?? (_addCommand = new RelayCommand(AddCommandExecute, AddCommandCanExecute));

        void AddCommandExecute(object param)
        {
            var fragment = new Fragment();
            var newFragment = new EditFragmentView(fragment);
            newFragment.ShowDialog();
            UpdateFragments();
        }

        bool AddCommandCanExecute(object param)
        {
            return true;
        }

        #endregion

        #region Edit

        RelayCommand _editCommand;
        public ICommand EditCommand => _editCommand ?? (_editCommand = new RelayCommand(EditCommandExecute, EditCommandCanExecute));

        void EditCommandExecute(object param)
        {
            var newFragment = new EditFragmentView(SelectedFragment);
            newFragment.ShowDialog();
            UpdateFragments();
        }

        bool EditCommandCanExecute(object param)
        {
            return SelectedFragment != null;
        }

        #endregion

        #region Delete

        RelayCommand _deleteCommand;
        public ICommand DeleteCommand => _deleteCommand ?? (_deleteCommand = new RelayCommand(DeleteCommandExecute, DeleteCommandCanExecute));

        void DeleteCommandExecute(object param)
        {
            SelectedFragment.RemoveFromDb();
            Fragments.Remove(SelectedFragment);
        }

        bool DeleteCommandCanExecute(object param)
        {
            return SelectedFragment != null;
        }

        #endregion

        public void UpdateFragments()
        {
            using (var db = new FragmentDb())
            {
                Fragments.Clear();

                foreach (var frag in db.Fragments)
                    Fragments.Add(frag);
            }
        }
    }
}
